/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameObjectConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RenameObjectConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RenameObjectRequest interceptRequest(RenameObjectRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RenameObjectRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRenameObjectDetails(), (String)"renameObjectDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("actions").path("renameObject");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, RenameObjectResponse> fromResponse() {
        Function<Response, RenameObjectResponse> transformer = new Function<Response, RenameObjectResponse>(){

            public RenameObjectResponse apply(Response rawResponse) {
                Optional versionIdHeader;
                Optional lastModifiedHeader;
                Optional eTagHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.RenameObjectResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RenameObjectResponse.Builder builder = RenameObjectResponse.builder();
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                if ((versionIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"version-id")).isPresent()) {
                    builder.versionId((String)HeaderUtils.toValue((String)"version-id", (String)((String)((List)versionIdHeader.get()).get(0)), String.class));
                }
                RenameObjectResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

