/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.ObjectLifecyclePolicy;
import com.oracle.bmc.objectstorage.requests.PutObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutObjectLifecyclePolicyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PutObjectLifecyclePolicyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PutObjectLifecyclePolicyRequest interceptRequest(PutObjectLifecyclePolicyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PutObjectLifecyclePolicyRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getPutObjectLifecyclePolicyDetails(), (String)"putObjectLifecyclePolicyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("l");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("if-none-match", (Object)request.getIfNoneMatch());
        }
        return ib;
    }

    public static Function<Response, PutObjectLifecyclePolicyResponse> fromResponse() {
        Function<Response, PutObjectLifecyclePolicyResponse> transformer = new Function<Response, PutObjectLifecyclePolicyResponse>(){

            public PutObjectLifecyclePolicyResponse apply(Response rawResponse) {
                Optional eTagHeader;
                Optional opcClientRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ObjectLifecyclePolicy.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                PutObjectLifecyclePolicyResponse.Builder builder = PutObjectLifecyclePolicyResponse.builder();
                builder.objectLifecyclePolicy((ObjectLifecyclePolicy)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id")).isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                PutObjectLifecyclePolicyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

