/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.internal.http.ObjectMetadataInterceptor;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutObjectConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PutObjectConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PutObjectRequest interceptRequest(PutObjectRequest request) {
        request = ObjectMetadataInterceptor.intercept(request);
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PutObjectRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getPutObjectBody(), (String)"putObjectBody is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("o").path(HttpUtils.encodePathSegment((String)request.getObjectName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("if-none-match", (Object)request.getIfNoneMatch());
        }
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        if (request.getExpect() != null) {
            ib.header("Expect", (Object)request.getExpect());
        }
        if (request.getContentLength() != null) {
            ib.header("Content-Length", (Object)request.getContentLength());
        }
        if (request.getContentMD5() != null) {
            ib.header("Content-MD5", (Object)request.getContentMD5());
        }
        if (request.getContentType() != null) {
            ib.header("Content-Type", (Object)request.getContentType());
        }
        if (request.getContentLanguage() != null) {
            ib.header("Content-Language", (Object)request.getContentLanguage());
        }
        if (request.getContentEncoding() != null) {
            ib.header("Content-Encoding", (Object)request.getContentEncoding());
        }
        if (request.getContentDisposition() != null) {
            ib.header("Content-Disposition", (Object)request.getContentDisposition());
        }
        if (request.getCacheControl() != null) {
            ib.header("Cache-Control", (Object)request.getCacheControl());
        }
        if (request.getOpcSseCustomerAlgorithm() != null) {
            ib.header("opc-sse-customer-algorithm", (Object)request.getOpcSseCustomerAlgorithm());
        }
        if (request.getOpcSseCustomerKey() != null) {
            ib.header("opc-sse-customer-key", (Object)request.getOpcSseCustomerKey());
        }
        if (request.getOpcSseCustomerKeySha256() != null) {
            ib.header("opc-sse-customer-key-sha256", (Object)request.getOpcSseCustomerKeySha256());
        }
        if (request.getOpcMeta() != null) {
            for (Map.Entry<String, String> header : request.getOpcMeta().entrySet()) {
                ib.header(header.getKey(), (Object)header.getValue());
            }
        }
        return ib;
    }

    public static Function<Response, PutObjectResponse> fromResponse() {
        Function<Response, PutObjectResponse> transformer = new Function<Response, PutObjectResponse>(){

            public PutObjectResponse apply(Response rawResponse) {
                Optional versionIdHeader;
                Optional lastModifiedHeader;
                Optional eTagHeader;
                Optional opcContentMd5Header;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.PutObjectResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                PutObjectResponse.Builder builder = PutObjectResponse.builder();
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcContentMd5Header = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-content-md5")).isPresent()) {
                    builder.opcContentMd5((String)HeaderUtils.toValue((String)"opc-content-md5", (String)((String)((List)opcContentMd5Header.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                if ((versionIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"version-id")).isPresent()) {
                    builder.versionId((String)HeaderUtils.toValue((String)"version-id", (String)((String)((List)versionIdHeader.get()).get(0)), String.class));
                }
                PutObjectResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

