/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.oracle.bmc.objectstorage.model.CopyObjectDetails;
import com.oracle.bmc.objectstorage.model.CreateMultipartUploadDetails;
import com.oracle.bmc.objectstorage.requests.CopyObjectRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadataInterceptor {
    private static final String USER_METADATA_PREFIX = "opc-meta-";

    public static CreateMultipartUploadRequest intercept(CreateMultipartUploadRequest request) {
        Map<String, String> newMetadata = ObjectMetadataInterceptor.toServiceMeta(request.getCreateMultipartUploadDetails().getMetadata());
        CreateMultipartUploadDetails newDetails = CreateMultipartUploadDetails.builder().copy(request.getCreateMultipartUploadDetails()).metadata(newMetadata).build();
        return CreateMultipartUploadRequest.builder().copy(request).createMultipartUploadDetails(newDetails).build();
    }

    public static CopyObjectRequest intercept(CopyObjectRequest request) {
        Map<String, String> newMetadata = ObjectMetadataInterceptor.toServiceMeta(request.getCopyObjectDetails().getDestinationObjectMetadata());
        CopyObjectDetails newDetails = CopyObjectDetails.builder().copy(request.getCopyObjectDetails()).destinationObjectMetadata(newMetadata).build();
        return CopyObjectRequest.builder().copy(request).copyObjectDetails(newDetails).build();
    }

    public static PutObjectRequest intercept(PutObjectRequest request) {
        Map<String, String> newMetadata = ObjectMetadataInterceptor.toServiceMeta(request.getOpcMeta());
        return PutObjectRequest.builder().copy(request).opcMeta(newMetadata).build();
    }

    public static HeadObjectResponse intercept(HeadObjectResponse response) {
        Map<String, String> newMetadata = ObjectMetadataInterceptor.fromServiceMeta(response.getOpcMeta());
        return HeadObjectResponse.builder().copy(response).opcMeta(newMetadata).build();
    }

    public static GetObjectResponse intercept(GetObjectResponse response) {
        Map<String, String> newMetadata = ObjectMetadataInterceptor.fromServiceMeta(response.getOpcMeta());
        return GetObjectResponse.builder().copy(response).opcMeta(newMetadata).build();
    }

    private static Map<String, String> toServiceMeta(Map<String, String> metadata) {
        HashMap<String, String> metadataCopy = null;
        if (metadata != null) {
            metadataCopy = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                metadataCopy.put(USER_METADATA_PREFIX + entry.getKey(), entry.getValue());
            }
        }
        return metadataCopy;
    }

    private static Map<String, String> fromServiceMeta(Map<String, String> metadata) {
        HashMap<String, String> metadataCopy = null;
        if (metadata != null) {
            metadataCopy = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                metadataCopy.put(entry.getKey().substring(USER_METADATA_PREFIX.length()), entry.getValue());
            }
        }
        return metadataCopy;
    }
}

