/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteObjectConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteObjectConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteObjectRequest interceptRequest(DeleteObjectRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteObjectRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("o").path(HttpUtils.encodePathSegment((String)request.getObjectName()));
        if (request.getVersionId() != null) {
            target = target.queryParam("versionId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getVersionId())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteObjectResponse> fromResponse() {
        Function<Response, DeleteObjectResponse> transformer = new Function<Response, DeleteObjectResponse>(){

            public DeleteObjectResponse apply(Response rawResponse) {
                Optional isDeleteMarkerHeader;
                Optional versionIdHeader;
                Optional lastModifiedHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.DeleteObjectResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteObjectResponse.Builder builder = DeleteObjectResponse.builder();
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                if ((versionIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"version-id")).isPresent()) {
                    builder.versionId((String)HeaderUtils.toValue((String)"version-id", (String)((String)((List)versionIdHeader.get()).get(0)), String.class));
                }
                if ((isDeleteMarkerHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"is-delete-marker")).isPresent()) {
                    builder.isDeleteMarker((Boolean)HeaderUtils.toValue((String)"is-delete-marker", (String)((String)((List)isDeleteMarkerHeader.get()).get(0)), Boolean.class));
                }
                DeleteObjectResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

