/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.http.client.io.DuplicatableInputStream;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.internal.ObjectStorageUtils;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.transfer.MultipartManifest;
import com.oracle.bmc.objectstorage.transfer.MultipartObjectAssembler;
import com.oracle.bmc.objectstorage.transfer.ProgressReporter;
import com.oracle.bmc.objectstorage.transfer.ProgressTrackerFactory;
import com.oracle.bmc.objectstorage.transfer.ProgressTrackingInputStreamFactory;
import com.oracle.bmc.objectstorage.transfer.UploadConfiguration;
import com.oracle.bmc.objectstorage.transfer.internal.MultipartUtils;
import com.oracle.bmc.objectstorage.transfer.internal.StreamChunkCreator;
import com.oracle.bmc.objectstorage.transfer.internal.StreamHelper;
import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(UploadManager.class);
    private static final int DEFAULT_NUM_MULTIPART_THREADS_PER_REQUEST = 3;
    private static final String UPLOAD_MANAGER_DEBUG_INFORMATION_LOG = String.format("\nClient Version: %s, OS Version: %s\nSee https://docs.oracle.com/iaas/Content/API/Concepts/sdk_troubleshooting.htm for common issues and steps to resolve them.\nIf you need to contact support, or file a GitHub issue, please include this full error message.", ClientRuntime.getRuntime().getClientInfo(), System.getProperty("os.version"));
    private static final RetryCondition RETRY_CONDITION = new DefaultRetryCondition(){

        public boolean shouldBeRetried(@Nonnull BmcException e) {
            if (e == null) {
                throw new NullPointerException("e is marked non-null but is null");
            }
            return super.shouldBeRetried(e) || e.getStatusCode() == -1 || e.getStatusCode() == 409 && "ConcurrentObjectUpdate".equals(e.getServiceCode());
        }
    };
    static final RetryConfiguration RETRY_CONFIGURATION = RetryConfiguration.builder().terminationStrategy((TerminationStrategy)new MaxAttemptsTerminationStrategy(5)).delayStrategy((DelayStrategy)new ExponentialBackoffDelayStrategy(100L)).retryCondition(exception -> RETRY_CONDITION.shouldBeRetried(exception)).build();
    private final ObjectStorage objectStorage;
    private final UploadConfiguration uploadConfiguration;

    public UploadResponse upload(UploadRequest uploadDetails) {
        if (MultipartUtils.shouldUseMultipart(this.uploadConfiguration, uploadDetails.putObjectRequest.getContentLength())) {
            return this.multipartUpload(uploadDetails);
        }
        return this.singleUpload(uploadDetails, uploadDetails.putObjectRequest.getContentLength());
    }

    private UploadResponse singleUpload(UploadRequest uploadRequest, long contentLength) {
        ProgressTrackerFactory progressTrackerFactory = ProgressTrackerFactory.createSingleUploadProgressTrackerFactory(uploadRequest.progressReporter, contentLength);
        PutObjectRequest putObjectRequest = uploadRequest.putObjectRequest;
        if (MultipartUtils.shouldCalculateMd5(this.uploadConfiguration, putObjectRequest)) {
            MD5Calculation md5Calculation = UploadManager.calculateMd5(putObjectRequest.getPutObjectBody(), putObjectRequest.getContentLength());
            putObjectRequest = PutObjectRequest.builder().copy(putObjectRequest).contentMD5(md5Calculation.md5).putObjectBody(ProgressTrackingInputStreamFactory.create(md5Calculation.streamToUse, progressTrackerFactory.getProgressTracker())).build();
        } else {
            putObjectRequest = PutObjectRequest.builder().copy(putObjectRequest).putObjectBody(ProgressTrackingInputStreamFactory.create(putObjectRequest.getPutObjectBody(), progressTrackerFactory.getProgressTracker())).build();
        }
        putObjectRequest.setRetryConfiguration(UploadManager.getRetryToUse(putObjectRequest.getRetryConfiguration()));
        PutObjectResponse response = this.objectStorage.putObject(putObjectRequest);
        return new UploadResponse(response.getETag(), response.getOpcContentMd5(), null, response.getOpcRequestId(), response.getOpcClientRequestId());
    }

    private UploadResponse multipartUpload(UploadRequest uploadRequest) {
        boolean shutdownExecutor;
        ExecutorService executorServiceToUse;
        PutObjectRequest request = uploadRequest.putObjectRequest;
        ProgressTrackerFactory progressTrackerFactory = ProgressTrackerFactory.createMultiPartUploadProgressTrackerFactory(uploadRequest.progressReporter, request.getContentLength());
        long sizePerPart = MultipartUtils.calculatePartSize(this.uploadConfiguration, request.getContentLength());
        StreamChunkCreator chunkCreator = new StreamChunkCreator(request.getPutObjectBody(), request.getContentLength(), sizePerPart);
        if (this.uploadConfiguration.isAllowParallelUploads() && chunkCreator.supportsParallelReads()) {
            if (uploadRequest.parallelUploadExecutorService != null) {
                executorServiceToUse = uploadRequest.parallelUploadExecutorService;
                shutdownExecutor = false;
            } else {
                executorServiceToUse = UploadManager.buildDefaultParallelExecutor();
                shutdownExecutor = true;
            }
        } else {
            executorServiceToUse = Executors.newSingleThreadExecutor();
            shutdownExecutor = true;
        }
        MultipartObjectAssembler assembler = this.createAssembler(request, uploadRequest, executorServiceToUse);
        MultipartManifest manifest = null;
        try {
            manifest = assembler.newRequest(request.getContentType(), request.getContentLanguage(), request.getContentEncoding(), request.getOpcMeta());
            int partCount = 0;
            while (chunkCreator.hasMore()) {
                LOG.trace("Creating part {}", (Object)(++partCount));
                StreamChunkCreator.SubRangeInputStream chunk = chunkCreator.next();
                if (this.uploadConfiguration.isEnforceMd5BeforeMultipartUpload()) {
                    MD5Calculation md5Calculation = UploadManager.calculateMd5(chunk, chunk.length());
                    assembler.addPart(ProgressTrackingInputStreamFactory.create(md5Calculation.streamToUse, progressTrackerFactory.getProgressTracker()), chunk.length(), md5Calculation.md5);
                    continue;
                }
                assembler.addPart(ProgressTrackingInputStreamFactory.create(chunk, progressTrackerFactory.getProgressTracker()), chunk.length(), null);
            }
            LOG.debug("Created {} parts", (Object)partCount);
            CommitMultipartUploadResponse response = assembler.commit();
            UploadResponse uploadResponse = new UploadResponse(response.getETag(), null, response.getOpcMultipartMd5(), response.getOpcRequestId(), response.getOpcClientRequestId());
            return uploadResponse;
        }
        catch (Exception e) {
            if (manifest != null) {
                LOG.error("Failed to upload object using multi-part uploads. Failed part numbers = '{}'. Successful parts = '{}'. {}", new Object[]{manifest.listFailedParts(), manifest.listCompletedParts(), UPLOAD_MANAGER_DEBUG_INFORMATION_LOG});
                if (this.uploadConfiguration.isDisableAutoAbort()) {
                    LOG.info("Not aborting failed multipart upload {} per configuration, client must manually abort it", (Object)manifest.getUploadId());
                } else {
                    try {
                        assembler.abort();
                    }
                    catch (Exception e2) {
                        LOG.warn("Failed to abort multipart upload {} after failure to upload object. {}", new Object[]{manifest.getUploadId(), UPLOAD_MANAGER_DEBUG_INFORMATION_LOG, e2});
                    }
                }
            }
            if (e instanceof BmcException) {
                throw e;
            }
            throw new BmcException(false, "Failed to upload object using multi-part uploads", (Throwable)e, null);
        }
        finally {
            StreamUtils.closeQuietly((InputStream)uploadRequest.putObjectRequest.getPutObjectBody());
            if (shutdownExecutor) {
                executorServiceToUse.shutdownNow();
            }
        }
    }

    private static RetryConfiguration getRetryToUse(RetryConfiguration ... configs) {
        for (RetryConfiguration cfg : configs) {
            if (cfg == null) continue;
            return cfg;
        }
        return RETRY_CONFIGURATION;
    }

    @VisibleForTesting
    protected MultipartObjectAssembler createAssembler(PutObjectRequest request, UploadRequest uploadRequest, ExecutorService executorService) {
        RetryConfiguration retryToUse = UploadManager.getRetryToUse(uploadRequest.putObjectRequest.getRetryConfiguration(), request.getRetryConfiguration());
        return MultipartObjectAssembler.builder().allowOverwrite(uploadRequest.allowOverwrite).bucketName(request.getBucketName()).executorService(executorService).invocationCallback(request.getInvocationCallback()).namespaceName(request.getNamespaceName()).objectName(request.getObjectName()).storageTier(request.getStorageTier()).opcClientRequestId(request.getOpcClientRequestId()).service(this.objectStorage).cacheControl(request.getCacheControl()).contentDisposition(request.getContentDisposition()).retryConfiguration(retryToUse).build();
    }

    private static ExecutorService buildDefaultParallelExecutor() {
        return Executors.newFixedThreadPool(3, (ThreadFactory)ClientThreadFactory.builder().nameFormat("multipart-upload-" + System.currentTimeMillis() + "-%d").isDaemon(true).build());
    }

    private static MD5Calculation calculateMd5(InputStream stream, Long contentLength) {
        String md5 = null;
        InputStream streamToReturn = null;
        if (stream instanceof DuplicatableInputStream) {
            md5 = UploadManager.performMd5Calculation(((DuplicatableInputStream)stream).duplicate(), new StreamHelper.NullOutputStream(), contentLength);
            streamToReturn = stream;
        } else {
            LOG.info("About to copy object into memory to calculate MD5, may lead to OutOfMemory exceptions");
            if (contentLength > Integer.MAX_VALUE) {
                throw new BmcException(false, "Cannot compute MD5 client-size as content length (" + contentLength + ") is larger than max buffer.  Disable MD5 enforcement or provide a DuplicableInputStream to avoid this problem", null, null);
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(contentLength.intValue());
                md5 = UploadManager.performMd5Calculation(stream, baos, contentLength);
                streamToReturn = StreamUtils.createByteArrayInputStream((byte[])baos.toByteArray());
            }
            catch (OutOfMemoryError oom) {
                OutOfMemoryError newOom = new OutOfMemoryError("Could not compute MD5.  Disable MD5 enforcement or provide a DuplicableInputStream to avoid this problem");
                newOom.initCause(oom);
                throw newOom;
            }
        }
        return new MD5Calculation(streamToReturn, md5);
    }

    private static String performMd5Calculation(InputStream stream, OutputStream outputStream, long contentLength) {
        long bytesCopied;
        DigestOutputStream digestOutputStream = StreamHelper.createMd5MessageOutputStream(outputStream);
        try {
            bytesCopied = StreamHelper.copy(stream, digestOutputStream);
        }
        catch (IOException e) {
            throw new BmcException(false, "Unable to calculate MD5", (Throwable)e, null);
        }
        if (bytesCopied != contentLength) {
            throw new BmcException(false, "Failed to read all bytes while calculating MD5: " + bytesCopied + ", " + contentLength, null, null);
        }
        return StreamHelper.base64Encode(digestOutputStream.getMessageDigest());
    }

    @ConstructorProperties(value={"objectStorage", "uploadConfiguration"})
    public UploadManager(ObjectStorage objectStorage, UploadConfiguration uploadConfiguration) {
        this.objectStorage = objectStorage;
        this.uploadConfiguration = uploadConfiguration;
    }

    private static class MD5Calculation {
        private final InputStream streamToUse;
        private final String md5;

        @ConstructorProperties(value={"streamToUse", "md5"})
        public MD5Calculation(InputStream streamToUse, String md5) {
            this.streamToUse = streamToUse;
            this.md5 = md5;
        }
    }

    public static class UploadResponse {
        private final String eTag;
        private final String contentMd5;
        private final String multipartMd5;
        private final String opcRequestId;
        private final String opcClientRequestId;

        @ConstructorProperties(value={"eTag", "contentMd5", "multipartMd5", "opcRequestId", "opcClientRequestId"})
        public UploadResponse(String eTag, String contentMd5, String multipartMd5, String opcRequestId, String opcClientRequestId) {
            this.eTag = eTag;
            this.contentMd5 = contentMd5;
            this.multipartMd5 = multipartMd5;
            this.opcRequestId = opcRequestId;
            this.opcClientRequestId = opcClientRequestId;
        }

        public String getETag() {
            return this.eTag;
        }

        public String getContentMd5() {
            return this.contentMd5;
        }

        public String getMultipartMd5() {
            return this.multipartMd5;
        }

        public String getOpcRequestId() {
            return this.opcRequestId;
        }

        public String getOpcClientRequestId() {
            return this.opcClientRequestId;
        }

        public String toString() {
            return "UploadManager.UploadResponse(eTag=" + this.getETag() + ", contentMd5=" + this.getContentMd5() + ", multipartMd5=" + this.getMultipartMd5() + ", opcRequestId=" + this.getOpcRequestId() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ")";
        }
    }

    public static class UploadRequest {
        private final PutObjectRequest putObjectRequest;
        private final ExecutorService parallelUploadExecutorService;
        private final boolean allowOverwrite;
        private final ProgressReporter progressReporter;

        public static UploadRequestBuilder builder(InputStream stream, long contentLength) {
            return new UploadRequestBuilder(stream, contentLength);
        }

        public static UploadRequestBuilder builder(File file) {
            InputStream stream = StreamUtils.toInputStream((File)file);
            try {
                return new UploadRequestBuilder(stream, file.length());
            }
            catch (Exception e) {
                StreamUtils.closeQuietly((InputStream)stream);
                throw e;
            }
        }

        @ConstructorProperties(value={"putObjectRequest", "parallelUploadExecutorService", "allowOverwrite", "progressReporter"})
        public UploadRequest(PutObjectRequest putObjectRequest, ExecutorService parallelUploadExecutorService, boolean allowOverwrite, ProgressReporter progressReporter) {
            this.putObjectRequest = putObjectRequest;
            this.parallelUploadExecutorService = parallelUploadExecutorService;
            this.allowOverwrite = allowOverwrite;
            this.progressReporter = progressReporter;
        }

        public static class UploadRequestBuilder {
            private final InputStream inputStream;
            private final long contentLength;
            private boolean allowOverwrite = true;
            private ExecutorService parallelUploadExecutorService;
            private ProgressReporter progressReporter;

            public UploadRequestBuilder allowOverwrite(boolean allowOverwrite) {
                this.allowOverwrite = allowOverwrite;
                return this;
            }

            public UploadRequestBuilder parallelUploadExecutorService(ExecutorService parallelUploadExecutorService) {
                this.parallelUploadExecutorService = parallelUploadExecutorService;
                return this;
            }

            public UploadRequestBuilder progressReporter(ProgressReporter progressReporter) {
                this.progressReporter = progressReporter;
                return this;
            }

            public UploadRequest build(PutObjectRequest request) {
                String ifNoneMatch = ObjectStorageUtils.getIfNoneMatchHeader(this.allowOverwrite);
                return new UploadRequest(PutObjectRequest.builder().copy(request).putObjectBody(this.inputStream).contentLength(Long.valueOf(this.contentLength)).ifNoneMatch(ifNoneMatch).build(), this.parallelUploadExecutorService, this.allowOverwrite, this.progressReporter);
            }

            @ConstructorProperties(value={"inputStream", "contentLength"})
            public UploadRequestBuilder(InputStream inputStream, long contentLength) {
                this.inputStream = inputStream;
                this.contentLength = contentLength;
            }
        }
    }
}

