/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.nosql.Nosql;
import com.oracle.bmc.nosql.NosqlAsyncClient;
import com.oracle.bmc.nosql.NosqlPaginators;
import com.oracle.bmc.nosql.NosqlWaiters;
import com.oracle.bmc.nosql.model.DeleteRowResult;
import com.oracle.bmc.nosql.model.Index;
import com.oracle.bmc.nosql.model.IndexCollection;
import com.oracle.bmc.nosql.model.PreparedStatement;
import com.oracle.bmc.nosql.model.QueryResultCollection;
import com.oracle.bmc.nosql.model.Row;
import com.oracle.bmc.nosql.model.StatementSummary;
import com.oracle.bmc.nosql.model.Table;
import com.oracle.bmc.nosql.model.TableCollection;
import com.oracle.bmc.nosql.model.TableUsageCollection;
import com.oracle.bmc.nosql.model.UpdateRowResult;
import com.oracle.bmc.nosql.model.WorkRequest;
import com.oracle.bmc.nosql.model.WorkRequestCollection;
import com.oracle.bmc.nosql.model.WorkRequestErrorCollection;
import com.oracle.bmc.nosql.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.nosql.requests.ChangeTableCompartmentRequest;
import com.oracle.bmc.nosql.requests.CreateIndexRequest;
import com.oracle.bmc.nosql.requests.CreateTableRequest;
import com.oracle.bmc.nosql.requests.DeleteIndexRequest;
import com.oracle.bmc.nosql.requests.DeleteRowRequest;
import com.oracle.bmc.nosql.requests.DeleteTableRequest;
import com.oracle.bmc.nosql.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.nosql.requests.GetIndexRequest;
import com.oracle.bmc.nosql.requests.GetRowRequest;
import com.oracle.bmc.nosql.requests.GetTableRequest;
import com.oracle.bmc.nosql.requests.GetWorkRequestRequest;
import com.oracle.bmc.nosql.requests.ListIndexesRequest;
import com.oracle.bmc.nosql.requests.ListTableUsageRequest;
import com.oracle.bmc.nosql.requests.ListTablesRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.nosql.requests.PrepareStatementRequest;
import com.oracle.bmc.nosql.requests.QueryRequest;
import com.oracle.bmc.nosql.requests.SummarizeStatementRequest;
import com.oracle.bmc.nosql.requests.UpdateRowRequest;
import com.oracle.bmc.nosql.requests.UpdateTableRequest;
import com.oracle.bmc.nosql.responses.ChangeTableCompartmentResponse;
import com.oracle.bmc.nosql.responses.CreateIndexResponse;
import com.oracle.bmc.nosql.responses.CreateTableResponse;
import com.oracle.bmc.nosql.responses.DeleteIndexResponse;
import com.oracle.bmc.nosql.responses.DeleteRowResponse;
import com.oracle.bmc.nosql.responses.DeleteTableResponse;
import com.oracle.bmc.nosql.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.nosql.responses.GetIndexResponse;
import com.oracle.bmc.nosql.responses.GetRowResponse;
import com.oracle.bmc.nosql.responses.GetTableResponse;
import com.oracle.bmc.nosql.responses.GetWorkRequestResponse;
import com.oracle.bmc.nosql.responses.ListIndexesResponse;
import com.oracle.bmc.nosql.responses.ListTableUsageResponse;
import com.oracle.bmc.nosql.responses.ListTablesResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.nosql.responses.PrepareStatementResponse;
import com.oracle.bmc.nosql.responses.QueryResponse;
import com.oracle.bmc.nosql.responses.SummarizeStatementResponse;
import com.oracle.bmc.nosql.responses.UpdateRowResponse;
import com.oracle.bmc.nosql.responses.UpdateTableResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NosqlClient
extends BaseSyncClient
implements Nosql {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOSQL").serviceEndpointPrefix("").serviceEndpointTemplate("https://nosql.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(NosqlAsyncClient.class);
    private final NosqlWaiters waiters;
    private final NosqlPaginators paginators;

    private NosqlClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Nosql-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new NosqlWaiters(executorService, this);
        this.paginators = new NosqlPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeTableCompartmentResponse changeTableCompartment(ChangeTableCompartmentRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTableCompartmentDetails(), "changeTableCompartmentDetails is required");
        return (ChangeTableCompartmentResponse)this.clientCall(request, ChangeTableCompartmentResponse::builder).logger(LOG, "changeTableCompartment").serviceDetails("Nosql", "ChangeTableCompartment", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/ChangeTableCompartment").method(Method.POST).requestBuilder(ChangeTableCompartmentRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeTableCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeTableCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateIndexDetails(), "createIndexDetails is required");
        return (CreateIndexResponse)this.clientCall(request, CreateIndexResponse::builder).logger(LOG, "createIndex").serviceDetails("Nosql", "CreateIndex", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Index/CreateIndex").method(Method.POST).requestBuilder(CreateIndexRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("indexes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateIndexResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIndexResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateTableResponse createTable(CreateTableRequest request) {
        Objects.requireNonNull(request.getCreateTableDetails(), "createTableDetails is required");
        return (CreateTableResponse)this.clientCall(request, CreateTableResponse::builder).logger(LOG, "createTable").serviceDetails("Nosql", "CreateTable", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/CreateTable").method(Method.POST).requestBuilder(CreateTableRequest::builder).basePath("/20190828").appendPathParam("tables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateTableResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIndexName(), (String)"indexName must not be blank", (Object[])new Object[0]);
        return (DeleteIndexResponse)this.clientCall(request, DeleteIndexResponse::builder).logger(LOG, "deleteIndex").serviceDetails("Nosql", "DeleteIndex", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Index/DeleteIndex").method(Method.DELETE).requestBuilder(DeleteIndexRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("indexes").appendPathParam(request.getIndexName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isIfExists", (Object)request.getIsIfExists()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteIndexResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIndexResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRowResponse deleteRow(DeleteRowRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getKey(), "key is required");
        return (DeleteRowResponse)this.clientCall(request, DeleteRowResponse::builder).logger(LOG, "deleteRow").serviceDetails("Nosql", "DeleteRow", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Row/DeleteRow").method(Method.DELETE).requestBuilder(DeleteRowRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("rows").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendQueryParam("isGetReturnRow", (Object)request.getIsGetReturnRow()).appendQueryParam("timeoutInMs", (Object)request.getTimeoutInMs()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeleteRowResult.class, DeleteRowResponse.Builder::deleteRowResult).handleResponseHeaderString("opc-request-id", DeleteRowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        return (DeleteTableResponse)this.clientCall(request, DeleteTableResponse::builder).logger(LOG, "deleteTable").serviceDetails("Nosql", "DeleteTable", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/DeleteTable").method(Method.DELETE).requestBuilder(DeleteTableRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isIfExists", (Object)request.getIsIfExists()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (DeleteWorkRequestResponse)this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("Nosql", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20190828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWorkRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIndexResponse getIndex(GetIndexRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getIndexName(), (String)"indexName must not be blank", (Object[])new Object[0]);
        return (GetIndexResponse)this.clientCall(request, GetIndexResponse::builder).logger(LOG, "getIndex").serviceDetails("Nosql", "GetIndex", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Index/GetIndex").method(Method.GET).requestBuilder(GetIndexRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("indexes").appendPathParam(request.getIndexName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Index.class, GetIndexResponse.Builder::index).handleResponseHeaderString("etag", GetIndexResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIndexResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetRowResponse getRow(GetRowRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getKey(), "key is required");
        return (GetRowResponse)this.clientCall(request, GetRowResponse::builder).logger(LOG, "getRow").serviceDetails("Nosql", "GetRow", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Row/GetRow").method(Method.GET).requestBuilder(GetRowRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("rows").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("key", request.getKey(), CollectionFormatType.Multi).appendEnumQueryParam("consistency", (BmcEnum)request.getConsistency()).appendQueryParam("timeoutInMs", (Object)request.getTimeoutInMs()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Row.class, GetRowResponse.Builder::row).handleResponseHeaderString("etag", GetRowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRowResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTableResponse getTable(GetTableRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        return (GetTableResponse)this.clientCall(request, GetTableResponse::builder).logger(LOG, "getTable").serviceDetails("Nosql", "GetTable", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/GetTable").method(Method.GET).requestBuilder(GetTableRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Table.class, GetTableResponse.Builder::table).handleResponseHeaderString("etag", GetTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTableResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Nosql", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListIndexesResponse listIndexes(ListIndexesRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        return (ListIndexesResponse)this.clientCall(request, ListIndexesResponse::builder).logger(LOG, "listIndexes").serviceDetails("Nosql", "ListIndexes", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Index/ListIndexes").method(Method.GET).requestBuilder(ListIndexesRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("indexes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IndexCollection.class, ListIndexesResponse.Builder::indexCollection).handleResponseHeaderString("opc-next-page", ListIndexesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIndexesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTableUsageResponse listTableUsage(ListTableUsageRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        return (ListTableUsageResponse)this.clientCall(request, ListTableUsageResponse::builder).logger(LOG, "listTableUsage").serviceDetails("Nosql", "ListTableUsage", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/ListTableUsage").method(Method.GET).requestBuilder(ListTableUsageRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("usage").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TableUsageCollection.class, ListTableUsageResponse.Builder::tableUsageCollection).handleResponseHeaderString("opc-next-page", ListTableUsageResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListTableUsageResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTablesResponse listTables(ListTablesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTablesResponse)this.clientCall(request, ListTablesResponse::builder).logger(LOG, "listTables").serviceDetails("Nosql", "ListTables", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/ListTables").method(Method.GET).requestBuilder(ListTablesRequest::builder).basePath("/20190828").appendPathParam("tables").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TableCollection.class, ListTablesResponse.Builder::tableCollection).handleResponseHeaderString("opc-next-page", ListTablesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListTablesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Nosql", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Nosql", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Nosql", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190828").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PrepareStatementResponse prepareStatement(PrepareStatementRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getStatement(), "statement is required");
        return (PrepareStatementResponse)this.clientCall(request, PrepareStatementResponse::builder).logger(LOG, "prepareStatement").serviceDetails("Nosql", "PrepareStatement", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/QueryResultCollection/PrepareStatement").method(Method.GET).requestBuilder(PrepareStatementRequest::builder).basePath("/20190828").appendPathParam("query").appendPathParam("prepare").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("statement", (Object)request.getStatement()).appendQueryParam("isGetQueryPlan", (Object)request.getIsGetQueryPlan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PreparedStatement.class, PrepareStatementResponse.Builder::preparedStatement).handleResponseHeaderString("opc-request-id", PrepareStatementResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public QueryResponse query(QueryRequest request) {
        Objects.requireNonNull(request.getQueryDetails(), "queryDetails is required");
        return (QueryResponse)this.clientCall(request, QueryResponse::builder).logger(LOG, "query").serviceDetails("Nosql", "Query", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/QueryResultCollection/Query").method(Method.POST).requestBuilder(QueryRequest::builder).basePath("/20190828").appendPathParam("query").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(QueryResultCollection.class, QueryResponse.Builder::queryResultCollection).handleResponseHeaderString("opc-next-page", QueryResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", QueryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SummarizeStatementResponse summarizeStatement(SummarizeStatementRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getStatement(), "statement is required");
        return (SummarizeStatementResponse)this.clientCall(request, SummarizeStatementResponse::builder).logger(LOG, "summarizeStatement").serviceDetails("Nosql", "SummarizeStatement", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/QueryResultCollection/SummarizeStatement").method(Method.GET).requestBuilder(SummarizeStatementRequest::builder).basePath("/20190828").appendPathParam("query").appendPathParam("summarize").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("statement", (Object)request.getStatement()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StatementSummary.class, SummarizeStatementResponse.Builder::statementSummary).handleResponseHeaderString("opc-request-id", SummarizeStatementResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateRowResponse updateRow(UpdateRowRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRowDetails(), "updateRowDetails is required");
        return (UpdateRowResponse)this.clientCall(request, UpdateRowResponse::builder).logger(LOG, "updateRow").serviceDetails("Nosql", "UpdateRow", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Row/UpdateRow").method(Method.PUT).requestBuilder(UpdateRowRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).appendPathParam("rows").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UpdateRowResult.class, UpdateRowResponse.Builder::updateRowResult).handleResponseHeaderString("etag", UpdateRowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest request) {
        Validate.notBlank((String)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTableDetails(), "updateTableDetails is required");
        return (UpdateTableResponse)this.clientCall(request, UpdateTableResponse::builder).logger(LOG, "updateTable").serviceDetails("Nosql", "UpdateTable", "https://docs.oracle.com/iaas/api/#/en/nosql-database/20190828/Table/UpdateTable").method(Method.PUT).requestBuilder(UpdateTableRequest::builder).basePath("/20190828").appendPathParam("tables").appendPathParam(request.getTableNameOrId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public NosqlWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public NosqlPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public NosqlClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)NosqlClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(NosqlClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)NosqlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)NosqlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)NosqlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)NosqlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NosqlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NosqlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NosqlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NosqlClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public NosqlClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new NosqlClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

