/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.responses;

import com.oracle.bmc.networkloadbalancer.model.BackendSet;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetBackendSetResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private BackendSet backendSet;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public BackendSet getBackendSet() {
        return this.backendSet;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "backendSet"})
    private GetBackendSetResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, BackendSet backendSet) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.backendSet = backendSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",backendSet=").append(String.valueOf((Object)this.backendSet));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBackendSetResponse)) {
            return false;
        }
        GetBackendSetResponse other = (GetBackendSetResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.backendSet, (Object)other.backendSet);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.backendSet == null ? 43 : this.backendSet.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetBackendSetResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private BackendSet backendSet;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder backendSet(BackendSet backendSet) {
            this.backendSet = backendSet;
            return this;
        }

        public Builder copy(GetBackendSetResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.backendSet(o.getBackendSet());
            return this;
        }

        public GetBackendSetResponse build() {
            return new GetBackendSetResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.backendSet);
        }
    }
}

