/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.responses;

import com.oracle.bmc.networkloadbalancer.model.BackendSetHealth;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetBackendSetHealthResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private BackendSetHealth backendSetHealth;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public BackendSetHealth getBackendSetHealth() {
        return this.backendSetHealth;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "backendSetHealth"})
    private GetBackendSetHealthResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, BackendSetHealth backendSetHealth) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.backendSetHealth = backendSetHealth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",backendSetHealth=").append(String.valueOf((Object)this.backendSetHealth));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBackendSetHealthResponse)) {
            return false;
        }
        GetBackendSetHealthResponse other = (GetBackendSetHealthResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.backendSetHealth, (Object)other.backendSetHealth);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.backendSetHealth == null ? 43 : this.backendSetHealth.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetBackendSetHealthResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private BackendSetHealth backendSetHealth;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder backendSetHealth(BackendSetHealth backendSetHealth) {
            this.backendSetHealth = backendSetHealth;
            return this;
        }

        public Builder copy(GetBackendSetHealthResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.backendSetHealth(o.getBackendSetHealth());
            return this;
        }

        public GetBackendSetHealthResponse build() {
            return new GetBackendSetHealthResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.backendSetHealth);
        }
    }
}

