/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.responses;

import com.oracle.bmc.networkloadbalancer.model.Backend;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetBackendResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private Backend backend;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Backend getBackend() {
        return this.backend;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "backend"})
    private GetBackendResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, Backend backend) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.backend = backend;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",backend=").append(String.valueOf((Object)this.backend));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBackendResponse)) {
            return false;
        }
        GetBackendResponse other = (GetBackendResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.backend, (Object)other.backend);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.backend == null ? 43 : this.backend.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetBackendResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private Backend backend;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder backend(Backend backend) {
            this.backend = backend;
            return this;
        }

        public Builder copy(GetBackendResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.backend(o.getBackend());
            return this;
        }

        public GetBackendResponse build() {
            return new GetBackendResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.backend);
        }
    }
}

