/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.networkloadbalancer.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListNetworkLoadBalancerHealthsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private Integer limit;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListNetworkLoadBalancerHealthsRequest)) {
            return false;
        }
        ListNetworkLoadBalancerHealthsRequest other = (ListNetworkLoadBalancerHealthsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListNetworkLoadBalancerHealthsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListNetworkLoadBalancerHealthsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListNetworkLoadBalancerHealthsRequest build() {
            ListNetworkLoadBalancerHealthsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListNetworkLoadBalancerHealthsRequest buildWithoutInvocationCallback() {
            ListNetworkLoadBalancerHealthsRequest request = new ListNetworkLoadBalancerHealthsRequest();
            request.compartmentId = this.compartmentId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

