/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNetworkLoadBalancerRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String ifNoneMatch;
    private String opcRequestId;

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().networkLoadBalancerId(this.networkLoadBalancerId).ifNoneMatch(this.ifNoneMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkLoadBalancerId=").append(String.valueOf(this.networkLoadBalancerId));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkLoadBalancerRequest)) {
            return false;
        }
        GetNetworkLoadBalancerRequest other = (GetNetworkLoadBalancerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkLoadBalancerId, other.networkLoadBalancerId) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkLoadBalancerId == null ? 43 : this.networkLoadBalancerId.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkLoadBalancerRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkLoadBalancerId = null;
        private String ifNoneMatch = null;
        private String opcRequestId = null;

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkLoadBalancerRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkLoadBalancerRequest build() {
            GetNetworkLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNetworkLoadBalancerRequest buildWithoutInvocationCallback() {
            GetNetworkLoadBalancerRequest request = new GetNetworkLoadBalancerRequest();
            request.networkLoadBalancerId = this.networkLoadBalancerId;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

