/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHealthCheckerRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String backendSetName;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifNoneMatch;

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public Builder toBuilder() {
        return new Builder().networkLoadBalancerId(this.networkLoadBalancerId).backendSetName(this.backendSetName).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifNoneMatch(this.ifNoneMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkLoadBalancerId=").append(String.valueOf(this.networkLoadBalancerId));
        sb.append(",backendSetName=").append(String.valueOf(this.backendSetName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHealthCheckerRequest)) {
            return false;
        }
        GetHealthCheckerRequest other = (GetHealthCheckerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkLoadBalancerId, other.networkLoadBalancerId) && Objects.equals(this.backendSetName, other.backendSetName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkLoadBalancerId == null ? 43 : this.networkLoadBalancerId.hashCode());
        result = result * 59 + (this.backendSetName == null ? 43 : this.backendSetName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHealthCheckerRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkLoadBalancerId = null;
        private String backendSetName = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifNoneMatch = null;

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHealthCheckerRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHealthCheckerRequest build() {
            GetHealthCheckerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHealthCheckerRequest buildWithoutInvocationCallback() {
            GetHealthCheckerRequest request = new GetHealthCheckerRequest();
            request.networkLoadBalancerId = this.networkLoadBalancerId;
            request.backendSetName = this.backendSetName;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifNoneMatch = this.ifNoneMatch;
            return request;
        }
    }
}

