/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetBackendHealthRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String backendSetName;
    private String backendName;
    private String opcRequestId;

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().networkLoadBalancerId(this.networkLoadBalancerId).backendSetName(this.backendSetName).backendName(this.backendName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkLoadBalancerId=").append(String.valueOf(this.networkLoadBalancerId));
        sb.append(",backendSetName=").append(String.valueOf(this.backendSetName));
        sb.append(",backendName=").append(String.valueOf(this.backendName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBackendHealthRequest)) {
            return false;
        }
        GetBackendHealthRequest other = (GetBackendHealthRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkLoadBalancerId, other.networkLoadBalancerId) && Objects.equals(this.backendSetName, other.backendSetName) && Objects.equals(this.backendName, other.backendName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkLoadBalancerId == null ? 43 : this.networkLoadBalancerId.hashCode());
        result = result * 59 + (this.backendSetName == null ? 43 : this.backendSetName.hashCode());
        result = result * 59 + (this.backendName == null ? 43 : this.backendName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBackendHealthRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkLoadBalancerId = null;
        private String backendSetName = null;
        private String backendName = null;
        private String opcRequestId = null;

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder backendName(String backendName) {
            this.backendName = backendName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBackendHealthRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.backendName(o.getBackendName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBackendHealthRequest build() {
            GetBackendHealthRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetBackendHealthRequest buildWithoutInvocationCallback() {
            GetBackendHealthRequest request = new GetBackendHealthRequest();
            request.networkLoadBalancerId = this.networkLoadBalancerId;
            request.backendSetName = this.backendSetName;
            request.backendName = this.backendName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

