/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkloadbalancer.model.BackendDetails;
import com.oracle.bmc.networkloadbalancer.model.HealthCheckerDetails;
import com.oracle.bmc.networkloadbalancer.model.IpVersion;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateBackendSetDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="policy")
    private final String policy;
    @JsonProperty(value="isPreserveSource")
    private final Boolean isPreserveSource;
    @JsonProperty(value="ipVersion")
    private final IpVersion ipVersion;
    @JsonProperty(value="backends")
    private final List<BackendDetails> backends;
    @JsonProperty(value="healthChecker")
    private final HealthCheckerDetails healthChecker;

    @Deprecated
    @ConstructorProperties(value={"policy", "isPreserveSource", "ipVersion", "backends", "healthChecker"})
    public UpdateBackendSetDetails(String policy, Boolean isPreserveSource, IpVersion ipVersion, List<BackendDetails> backends, HealthCheckerDetails healthChecker) {
        this.policy = policy;
        this.isPreserveSource = isPreserveSource;
        this.ipVersion = ipVersion;
        this.backends = backends;
        this.healthChecker = healthChecker;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPolicy() {
        return this.policy;
    }

    public Boolean getIsPreserveSource() {
        return this.isPreserveSource;
    }

    public IpVersion getIpVersion() {
        return this.ipVersion;
    }

    public List<BackendDetails> getBackends() {
        return this.backends;
    }

    public HealthCheckerDetails getHealthChecker() {
        return this.healthChecker;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateBackendSetDetails(");
        sb.append("super=").append(super.toString());
        sb.append("policy=").append(String.valueOf(this.policy));
        sb.append(", isPreserveSource=").append(String.valueOf(this.isPreserveSource));
        sb.append(", ipVersion=").append(String.valueOf((Object)this.ipVersion));
        sb.append(", backends=").append(String.valueOf(this.backends));
        sb.append(", healthChecker=").append(String.valueOf((Object)this.healthChecker));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBackendSetDetails)) {
            return false;
        }
        UpdateBackendSetDetails other = (UpdateBackendSetDetails)((Object)o);
        return Objects.equals(this.policy, other.policy) && Objects.equals(this.isPreserveSource, other.isPreserveSource) && Objects.equals((Object)this.ipVersion, (Object)other.ipVersion) && Objects.equals(this.backends, other.backends) && Objects.equals((Object)this.healthChecker, (Object)other.healthChecker) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.policy == null ? 43 : this.policy.hashCode());
        result = result * 59 + (this.isPreserveSource == null ? 43 : this.isPreserveSource.hashCode());
        result = result * 59 + (this.ipVersion == null ? 43 : this.ipVersion.hashCode());
        result = result * 59 + (this.backends == null ? 43 : this.backends.hashCode());
        result = result * 59 + (this.healthChecker == null ? 43 : this.healthChecker.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="policy")
        private String policy;
        @JsonProperty(value="isPreserveSource")
        private Boolean isPreserveSource;
        @JsonProperty(value="ipVersion")
        private IpVersion ipVersion;
        @JsonProperty(value="backends")
        private List<BackendDetails> backends;
        @JsonProperty(value="healthChecker")
        private HealthCheckerDetails healthChecker;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder policy(String policy) {
            this.policy = policy;
            this.__explicitlySet__.add("policy");
            return this;
        }

        public Builder isPreserveSource(Boolean isPreserveSource) {
            this.isPreserveSource = isPreserveSource;
            this.__explicitlySet__.add("isPreserveSource");
            return this;
        }

        public Builder ipVersion(IpVersion ipVersion) {
            this.ipVersion = ipVersion;
            this.__explicitlySet__.add("ipVersion");
            return this;
        }

        public Builder backends(List<BackendDetails> backends) {
            this.backends = backends;
            this.__explicitlySet__.add("backends");
            return this;
        }

        public Builder healthChecker(HealthCheckerDetails healthChecker) {
            this.healthChecker = healthChecker;
            this.__explicitlySet__.add("healthChecker");
            return this;
        }

        public UpdateBackendSetDetails build() {
            UpdateBackendSetDetails model = new UpdateBackendSetDetails(this.policy, this.isPreserveSource, this.ipVersion, this.backends, this.healthChecker);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateBackendSetDetails model) {
            if (model.wasPropertyExplicitlySet("policy")) {
                this.policy(model.getPolicy());
            }
            if (model.wasPropertyExplicitlySet("isPreserveSource")) {
                this.isPreserveSource(model.getIsPreserveSource());
            }
            if (model.wasPropertyExplicitlySet("ipVersion")) {
                this.ipVersion(model.getIpVersion());
            }
            if (model.wasPropertyExplicitlySet("backends")) {
                this.backends(model.getBackends());
            }
            if (model.wasPropertyExplicitlySet("healthChecker")) {
                this.healthChecker(model.getHealthChecker());
            }
            return this;
        }
    }
}

