/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkloadbalancer.model.BackendSet;
import com.oracle.bmc.networkloadbalancer.model.IpAddress;
import com.oracle.bmc.networkloadbalancer.model.LifecycleState;
import com.oracle.bmc.networkloadbalancer.model.Listener;
import com.oracle.bmc.networkloadbalancer.model.NlbIpVersion;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkLoadBalancerSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="nlbIpVersion")
    private final NlbIpVersion nlbIpVersion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="ipAddresses")
    private final List<IpAddress> ipAddresses;
    @JsonProperty(value="isPrivate")
    private final Boolean isPrivate;
    @JsonProperty(value="isPreserveSourceDestination")
    private final Boolean isPreserveSourceDestination;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;
    @JsonProperty(value="listeners")
    private final Map<String, Listener> listeners;
    @JsonProperty(value="backendSets")
    private final Map<String, BackendSet> backendSets;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "lifecycleState", "lifecycleDetails", "nlbIpVersion", "timeCreated", "timeUpdated", "ipAddresses", "isPrivate", "isPreserveSourceDestination", "subnetId", "networkSecurityGroupIds", "listeners", "backendSets", "freeformTags", "definedTags", "systemTags"})
    public NetworkLoadBalancerSummary(String id, String compartmentId, String displayName, LifecycleState lifecycleState, String lifecycleDetails, NlbIpVersion nlbIpVersion, Date timeCreated, Date timeUpdated, List<IpAddress> ipAddresses, Boolean isPrivate, Boolean isPreserveSourceDestination, String subnetId, List<String> networkSecurityGroupIds, Map<String, Listener> listeners, Map<String, BackendSet> backendSets, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.nlbIpVersion = nlbIpVersion;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.ipAddresses = ipAddresses;
        this.isPrivate = isPrivate;
        this.isPreserveSourceDestination = isPreserveSourceDestination;
        this.subnetId = subnetId;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
        this.listeners = listeners;
        this.backendSets = backendSets;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public NlbIpVersion getNlbIpVersion() {
        return this.nlbIpVersion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public List<IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public Boolean getIsPreserveSourceDestination() {
        return this.isPreserveSourceDestination;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public Map<String, Listener> getListeners() {
        return this.listeners;
    }

    public Map<String, BackendSet> getBackendSets() {
        return this.backendSets;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkLoadBalancerSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", nlbIpVersion=").append(String.valueOf((Object)this.nlbIpVersion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", ipAddresses=").append(String.valueOf(this.ipAddresses));
        sb.append(", isPrivate=").append(String.valueOf(this.isPrivate));
        sb.append(", isPreserveSourceDestination=").append(String.valueOf(this.isPreserveSourceDestination));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(", listeners=").append(String.valueOf(this.listeners));
        sb.append(", backendSets=").append(String.valueOf(this.backendSets));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkLoadBalancerSummary)) {
            return false;
        }
        NetworkLoadBalancerSummary other = (NetworkLoadBalancerSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.nlbIpVersion, (Object)other.nlbIpVersion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.ipAddresses, other.ipAddresses) && Objects.equals(this.isPrivate, other.isPrivate) && Objects.equals(this.isPreserveSourceDestination, other.isPreserveSourceDestination) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && Objects.equals(this.listeners, other.listeners) && Objects.equals(this.backendSets, other.backendSets) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.nlbIpVersion == null ? 43 : this.nlbIpVersion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.ipAddresses == null ? 43 : this.ipAddresses.hashCode());
        result = result * 59 + (this.isPrivate == null ? 43 : this.isPrivate.hashCode());
        result = result * 59 + (this.isPreserveSourceDestination == null ? 43 : this.isPreserveSourceDestination.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + (this.listeners == null ? 43 : this.listeners.hashCode());
        result = result * 59 + (this.backendSets == null ? 43 : this.backendSets.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="nlbIpVersion")
        private NlbIpVersion nlbIpVersion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="ipAddresses")
        private List<IpAddress> ipAddresses;
        @JsonProperty(value="isPrivate")
        private Boolean isPrivate;
        @JsonProperty(value="isPreserveSourceDestination")
        private Boolean isPreserveSourceDestination;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonProperty(value="listeners")
        private Map<String, Listener> listeners;
        @JsonProperty(value="backendSets")
        private Map<String, BackendSet> backendSets;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder nlbIpVersion(NlbIpVersion nlbIpVersion) {
            this.nlbIpVersion = nlbIpVersion;
            this.__explicitlySet__.add("nlbIpVersion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder ipAddresses(List<IpAddress> ipAddresses) {
            this.ipAddresses = ipAddresses;
            this.__explicitlySet__.add("ipAddresses");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.__explicitlySet__.add("isPrivate");
            return this;
        }

        public Builder isPreserveSourceDestination(Boolean isPreserveSourceDestination) {
            this.isPreserveSourceDestination = isPreserveSourceDestination;
            this.__explicitlySet__.add("isPreserveSourceDestination");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public Builder listeners(Map<String, Listener> listeners) {
            this.listeners = listeners;
            this.__explicitlySet__.add("listeners");
            return this;
        }

        public Builder backendSets(Map<String, BackendSet> backendSets) {
            this.backendSets = backendSets;
            this.__explicitlySet__.add("backendSets");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public NetworkLoadBalancerSummary build() {
            NetworkLoadBalancerSummary model = new NetworkLoadBalancerSummary(this.id, this.compartmentId, this.displayName, this.lifecycleState, this.lifecycleDetails, this.nlbIpVersion, this.timeCreated, this.timeUpdated, this.ipAddresses, this.isPrivate, this.isPreserveSourceDestination, this.subnetId, this.networkSecurityGroupIds, this.listeners, this.backendSets, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkLoadBalancerSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("nlbIpVersion")) {
                this.nlbIpVersion(model.getNlbIpVersion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("ipAddresses")) {
                this.ipAddresses(model.getIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("isPrivate")) {
                this.isPrivate(model.getIsPrivate());
            }
            if (model.wasPropertyExplicitlySet("isPreserveSourceDestination")) {
                this.isPreserveSourceDestination(model.getIsPreserveSourceDestination());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            if (model.wasPropertyExplicitlySet("listeners")) {
                this.listeners(model.getListeners());
            }
            if (model.wasPropertyExplicitlySet("backendSets")) {
                this.backendSets(model.getBackendSets());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

