/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkLoadBalancerHealth
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="warningStateBackendSetNames")
    private final List<String> warningStateBackendSetNames;
    @JsonProperty(value="criticalStateBackendSetNames")
    private final List<String> criticalStateBackendSetNames;
    @JsonProperty(value="unknownStateBackendSetNames")
    private final List<String> unknownStateBackendSetNames;
    @JsonProperty(value="totalBackendSetCount")
    private final Integer totalBackendSetCount;

    @Deprecated
    @ConstructorProperties(value={"status", "warningStateBackendSetNames", "criticalStateBackendSetNames", "unknownStateBackendSetNames", "totalBackendSetCount"})
    public NetworkLoadBalancerHealth(Status status, List<String> warningStateBackendSetNames, List<String> criticalStateBackendSetNames, List<String> unknownStateBackendSetNames, Integer totalBackendSetCount) {
        this.status = status;
        this.warningStateBackendSetNames = warningStateBackendSetNames;
        this.criticalStateBackendSetNames = criticalStateBackendSetNames;
        this.unknownStateBackendSetNames = unknownStateBackendSetNames;
        this.totalBackendSetCount = totalBackendSetCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<String> getWarningStateBackendSetNames() {
        return this.warningStateBackendSetNames;
    }

    public List<String> getCriticalStateBackendSetNames() {
        return this.criticalStateBackendSetNames;
    }

    public List<String> getUnknownStateBackendSetNames() {
        return this.unknownStateBackendSetNames;
    }

    public Integer getTotalBackendSetCount() {
        return this.totalBackendSetCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkLoadBalancerHealth(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", warningStateBackendSetNames=").append(String.valueOf(this.warningStateBackendSetNames));
        sb.append(", criticalStateBackendSetNames=").append(String.valueOf(this.criticalStateBackendSetNames));
        sb.append(", unknownStateBackendSetNames=").append(String.valueOf(this.unknownStateBackendSetNames));
        sb.append(", totalBackendSetCount=").append(String.valueOf(this.totalBackendSetCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkLoadBalancerHealth)) {
            return false;
        }
        NetworkLoadBalancerHealth other = (NetworkLoadBalancerHealth)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.warningStateBackendSetNames, other.warningStateBackendSetNames) && Objects.equals(this.criticalStateBackendSetNames, other.criticalStateBackendSetNames) && Objects.equals(this.unknownStateBackendSetNames, other.unknownStateBackendSetNames) && Objects.equals(this.totalBackendSetCount, other.totalBackendSetCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.warningStateBackendSetNames == null ? 43 : this.warningStateBackendSetNames.hashCode());
        result = result * 59 + (this.criticalStateBackendSetNames == null ? 43 : this.criticalStateBackendSetNames.hashCode());
        result = result * 59 + (this.unknownStateBackendSetNames == null ? 43 : this.unknownStateBackendSetNames.hashCode());
        result = result * 59 + (this.totalBackendSetCount == null ? 43 : this.totalBackendSetCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Ok("OK"),
        Warning("WARNING"),
        Critical("CRITICAL"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="warningStateBackendSetNames")
        private List<String> warningStateBackendSetNames;
        @JsonProperty(value="criticalStateBackendSetNames")
        private List<String> criticalStateBackendSetNames;
        @JsonProperty(value="unknownStateBackendSetNames")
        private List<String> unknownStateBackendSetNames;
        @JsonProperty(value="totalBackendSetCount")
        private Integer totalBackendSetCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder warningStateBackendSetNames(List<String> warningStateBackendSetNames) {
            this.warningStateBackendSetNames = warningStateBackendSetNames;
            this.__explicitlySet__.add("warningStateBackendSetNames");
            return this;
        }

        public Builder criticalStateBackendSetNames(List<String> criticalStateBackendSetNames) {
            this.criticalStateBackendSetNames = criticalStateBackendSetNames;
            this.__explicitlySet__.add("criticalStateBackendSetNames");
            return this;
        }

        public Builder unknownStateBackendSetNames(List<String> unknownStateBackendSetNames) {
            this.unknownStateBackendSetNames = unknownStateBackendSetNames;
            this.__explicitlySet__.add("unknownStateBackendSetNames");
            return this;
        }

        public Builder totalBackendSetCount(Integer totalBackendSetCount) {
            this.totalBackendSetCount = totalBackendSetCount;
            this.__explicitlySet__.add("totalBackendSetCount");
            return this;
        }

        public NetworkLoadBalancerHealth build() {
            NetworkLoadBalancerHealth model = new NetworkLoadBalancerHealth(this.status, this.warningStateBackendSetNames, this.criticalStateBackendSetNames, this.unknownStateBackendSetNames, this.totalBackendSetCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkLoadBalancerHealth model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("warningStateBackendSetNames")) {
                this.warningStateBackendSetNames(model.getWarningStateBackendSetNames());
            }
            if (model.wasPropertyExplicitlySet("criticalStateBackendSetNames")) {
                this.criticalStateBackendSetNames(model.getCriticalStateBackendSetNames());
            }
            if (model.wasPropertyExplicitlySet("unknownStateBackendSetNames")) {
                this.unknownStateBackendSetNames(model.getUnknownStateBackendSetNames());
            }
            if (model.wasPropertyExplicitlySet("totalBackendSetCount")) {
                this.totalBackendSetCount(model.getTotalBackendSetCount());
            }
            return this;
        }
    }
}

