/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkloadbalancer.model.IpVersion;
import com.oracle.bmc.networkloadbalancer.model.ListenerProtocols;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ListenerSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="defaultBackendSetName")
    private final String defaultBackendSetName;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="protocol")
    private final ListenerProtocols protocol;
    @JsonProperty(value="ipVersion")
    private final IpVersion ipVersion;

    @Deprecated
    @ConstructorProperties(value={"name", "defaultBackendSetName", "port", "protocol", "ipVersion"})
    public ListenerSummary(String name, String defaultBackendSetName, Integer port, ListenerProtocols protocol, IpVersion ipVersion) {
        this.name = name;
        this.defaultBackendSetName = defaultBackendSetName;
        this.port = port;
        this.protocol = protocol;
        this.ipVersion = ipVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultBackendSetName() {
        return this.defaultBackendSetName;
    }

    public Integer getPort() {
        return this.port;
    }

    public ListenerProtocols getProtocol() {
        return this.protocol;
    }

    public IpVersion getIpVersion() {
        return this.ipVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ListenerSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", defaultBackendSetName=").append(String.valueOf(this.defaultBackendSetName));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", ipVersion=").append(String.valueOf((Object)this.ipVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListenerSummary)) {
            return false;
        }
        ListenerSummary other = (ListenerSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.defaultBackendSetName, other.defaultBackendSetName) && Objects.equals(this.port, other.port) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals((Object)this.ipVersion, (Object)other.ipVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.defaultBackendSetName == null ? 43 : this.defaultBackendSetName.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.ipVersion == null ? 43 : this.ipVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="defaultBackendSetName")
        private String defaultBackendSetName;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="protocol")
        private ListenerProtocols protocol;
        @JsonProperty(value="ipVersion")
        private IpVersion ipVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder defaultBackendSetName(String defaultBackendSetName) {
            this.defaultBackendSetName = defaultBackendSetName;
            this.__explicitlySet__.add("defaultBackendSetName");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder protocol(ListenerProtocols protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder ipVersion(IpVersion ipVersion) {
            this.ipVersion = ipVersion;
            this.__explicitlySet__.add("ipVersion");
            return this;
        }

        public ListenerSummary build() {
            ListenerSummary model = new ListenerSummary(this.name, this.defaultBackendSetName, this.port, this.protocol, this.ipVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ListenerSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("defaultBackendSetName")) {
                this.defaultBackendSetName(model.getDefaultBackendSetName());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("ipVersion")) {
                this.ipVersion(model.getIpVersion());
            }
            return this;
        }
    }
}

