/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkloadbalancer.model.IpVersion;
import com.oracle.bmc.networkloadbalancer.model.ListenerProtocols;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ListenerDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="defaultBackendSetName")
    private final String defaultBackendSetName;
    @JsonProperty(value="ipVersion")
    private final IpVersion ipVersion;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="protocol")
    private final ListenerProtocols protocol;

    @Deprecated
    @ConstructorProperties(value={"name", "defaultBackendSetName", "ipVersion", "port", "protocol"})
    public ListenerDetails(String name, String defaultBackendSetName, IpVersion ipVersion, Integer port, ListenerProtocols protocol) {
        this.name = name;
        this.defaultBackendSetName = defaultBackendSetName;
        this.ipVersion = ipVersion;
        this.port = port;
        this.protocol = protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultBackendSetName() {
        return this.defaultBackendSetName;
    }

    public IpVersion getIpVersion() {
        return this.ipVersion;
    }

    public Integer getPort() {
        return this.port;
    }

    public ListenerProtocols getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ListenerDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", defaultBackendSetName=").append(String.valueOf(this.defaultBackendSetName));
        sb.append(", ipVersion=").append(String.valueOf((Object)this.ipVersion));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListenerDetails)) {
            return false;
        }
        ListenerDetails other = (ListenerDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.defaultBackendSetName, other.defaultBackendSetName) && Objects.equals((Object)this.ipVersion, (Object)other.ipVersion) && Objects.equals(this.port, other.port) && Objects.equals((Object)this.protocol, (Object)other.protocol) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.defaultBackendSetName == null ? 43 : this.defaultBackendSetName.hashCode());
        result = result * 59 + (this.ipVersion == null ? 43 : this.ipVersion.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="defaultBackendSetName")
        private String defaultBackendSetName;
        @JsonProperty(value="ipVersion")
        private IpVersion ipVersion;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="protocol")
        private ListenerProtocols protocol;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder defaultBackendSetName(String defaultBackendSetName) {
            this.defaultBackendSetName = defaultBackendSetName;
            this.__explicitlySet__.add("defaultBackendSetName");
            return this;
        }

        public Builder ipVersion(IpVersion ipVersion) {
            this.ipVersion = ipVersion;
            this.__explicitlySet__.add("ipVersion");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder protocol(ListenerProtocols protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public ListenerDetails build() {
            ListenerDetails model = new ListenerDetails(this.name, this.defaultBackendSetName, this.ipVersion, this.port, this.protocol);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ListenerDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("defaultBackendSetName")) {
                this.defaultBackendSetName(model.getDefaultBackendSetName());
            }
            if (model.wasPropertyExplicitlySet("ipVersion")) {
                this.ipVersion(model.getIpVersion());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            return this;
        }
    }
}

