/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkloadbalancer.model.IpVersion;
import com.oracle.bmc.networkloadbalancer.model.ReservedIP;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IpAddress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="isPublic")
    private final Boolean isPublic;
    @JsonProperty(value="ipVersion")
    private final IpVersion ipVersion;
    @JsonProperty(value="reservedIp")
    private final ReservedIP reservedIp;

    @Deprecated
    @ConstructorProperties(value={"ipAddress", "isPublic", "ipVersion", "reservedIp"})
    public IpAddress(String ipAddress, Boolean isPublic, IpVersion ipVersion, ReservedIP reservedIp) {
        this.ipAddress = ipAddress;
        this.isPublic = isPublic;
        this.ipVersion = ipVersion;
        this.reservedIp = reservedIp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public IpVersion getIpVersion() {
        return this.ipVersion;
    }

    public ReservedIP getReservedIp() {
        return this.reservedIp;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IpAddress(");
        sb.append("super=").append(super.toString());
        sb.append("ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", isPublic=").append(String.valueOf(this.isPublic));
        sb.append(", ipVersion=").append(String.valueOf((Object)this.ipVersion));
        sb.append(", reservedIp=").append(String.valueOf((Object)this.reservedIp));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpAddress)) {
            return false;
        }
        IpAddress other = (IpAddress)((Object)o);
        return Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.isPublic, other.isPublic) && Objects.equals((Object)this.ipVersion, (Object)other.ipVersion) && Objects.equals((Object)this.reservedIp, (Object)other.reservedIp) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.isPublic == null ? 43 : this.isPublic.hashCode());
        result = result * 59 + (this.ipVersion == null ? 43 : this.ipVersion.hashCode());
        result = result * 59 + (this.reservedIp == null ? 43 : this.reservedIp.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="isPublic")
        private Boolean isPublic;
        @JsonProperty(value="ipVersion")
        private IpVersion ipVersion;
        @JsonProperty(value="reservedIp")
        private ReservedIP reservedIp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            this.__explicitlySet__.add("isPublic");
            return this;
        }

        public Builder ipVersion(IpVersion ipVersion) {
            this.ipVersion = ipVersion;
            this.__explicitlySet__.add("ipVersion");
            return this;
        }

        public Builder reservedIp(ReservedIP reservedIp) {
            this.reservedIp = reservedIp;
            this.__explicitlySet__.add("reservedIp");
            return this;
        }

        public IpAddress build() {
            IpAddress model = new IpAddress(this.ipAddress, this.isPublic, this.ipVersion, this.reservedIp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IpAddress model) {
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("isPublic")) {
                this.isPublic(model.getIsPublic());
            }
            if (model.wasPropertyExplicitlySet("ipVersion")) {
                this.ipVersion(model.getIpVersion());
            }
            if (model.wasPropertyExplicitlySet("reservedIp")) {
                this.reservedIp(model.getReservedIp());
            }
            return this;
        }
    }
}

