/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HealthCheckResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="healthCheckStatus")
    private final HealthCheckStatus healthCheckStatus;

    @Deprecated
    @ConstructorProperties(value={"timestamp", "healthCheckStatus"})
    public HealthCheckResult(Date timestamp, HealthCheckStatus healthCheckStatus) {
        this.timestamp = timestamp;
        this.healthCheckStatus = healthCheckStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public HealthCheckStatus getHealthCheckStatus() {
        return this.healthCheckStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HealthCheckResult(");
        sb.append("super=").append(super.toString());
        sb.append("timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", healthCheckStatus=").append(String.valueOf((Object)this.healthCheckStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HealthCheckResult)) {
            return false;
        }
        HealthCheckResult other = (HealthCheckResult)((Object)o);
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals((Object)this.healthCheckStatus, (Object)other.healthCheckStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.healthCheckStatus == null ? 43 : this.healthCheckStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum HealthCheckStatus implements BmcEnum
    {
        Ok("OK"),
        InvalidStatusCode("INVALID_STATUS_CODE"),
        TimedOut("TIMED_OUT"),
        HealthPayloadMismatch("HEALTH_PAYLOAD_MISMATCH"),
        ConnectFailed("CONNECT_FAILED"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HealthCheckStatus> map;

        private HealthCheckStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HealthCheckStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HealthCheckStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HealthCheckStatus.class);
            map = new HashMap<String, HealthCheckStatus>();
            for (HealthCheckStatus v : HealthCheckStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="healthCheckStatus")
        private HealthCheckStatus healthCheckStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder healthCheckStatus(HealthCheckStatus healthCheckStatus) {
            this.healthCheckStatus = healthCheckStatus;
            this.__explicitlySet__.add("healthCheckStatus");
            return this;
        }

        public HealthCheckResult build() {
            HealthCheckResult model = new HealthCheckResult(this.timestamp, this.healthCheckStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HealthCheckResult model) {
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("healthCheckStatus")) {
                this.healthCheckStatus(model.getHealthCheckStatus());
            }
            return this;
        }
    }
}

