/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum HcsInfraIpVersion implements BmcEnum
{
    Ipv4("IPV4"),
    Ipv4AndIpv6("IPV4_AND_IPV6");

    private final String value;
    private static Map<String, HcsInfraIpVersion> map;

    private HcsInfraIpVersion(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static HcsInfraIpVersion create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid HcsInfraIpVersion: " + key);
    }

    static {
        map = new HashMap<String, HcsInfraIpVersion>();
        for (HcsInfraIpVersion v : HcsInfraIpVersion.values()) {
            map.put(v.getValue(), v);
        }
    }
}

