/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkloadbalancer.model.BackendSetDetails;
import com.oracle.bmc.networkloadbalancer.model.ListenerDetails;
import com.oracle.bmc.networkloadbalancer.model.NlbIpVersion;
import com.oracle.bmc.networkloadbalancer.model.ReservedIP;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateNetworkLoadBalancerDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="isPreserveSourceDestination")
    private final Boolean isPreserveSourceDestination;
    @JsonProperty(value="reservedIps")
    private final List<ReservedIP> reservedIps;
    @JsonProperty(value="isPrivate")
    private final Boolean isPrivate;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;
    @JsonProperty(value="nlbIpVersion")
    private final NlbIpVersion nlbIpVersion;
    @JsonProperty(value="listeners")
    private final Map<String, ListenerDetails> listeners;
    @JsonProperty(value="backendSets")
    private final Map<String, BackendSetDetails> backendSets;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "isPreserveSourceDestination", "reservedIps", "isPrivate", "subnetId", "networkSecurityGroupIds", "nlbIpVersion", "listeners", "backendSets", "freeformTags", "definedTags"})
    public CreateNetworkLoadBalancerDetails(String compartmentId, String displayName, Boolean isPreserveSourceDestination, List<ReservedIP> reservedIps, Boolean isPrivate, String subnetId, List<String> networkSecurityGroupIds, NlbIpVersion nlbIpVersion, Map<String, ListenerDetails> listeners, Map<String, BackendSetDetails> backendSets, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.isPreserveSourceDestination = isPreserveSourceDestination;
        this.reservedIps = reservedIps;
        this.isPrivate = isPrivate;
        this.subnetId = subnetId;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
        this.nlbIpVersion = nlbIpVersion;
        this.listeners = listeners;
        this.backendSets = backendSets;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsPreserveSourceDestination() {
        return this.isPreserveSourceDestination;
    }

    public List<ReservedIP> getReservedIps() {
        return this.reservedIps;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public NlbIpVersion getNlbIpVersion() {
        return this.nlbIpVersion;
    }

    public Map<String, ListenerDetails> getListeners() {
        return this.listeners;
    }

    public Map<String, BackendSetDetails> getBackendSets() {
        return this.backendSets;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateNetworkLoadBalancerDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", isPreserveSourceDestination=").append(String.valueOf(this.isPreserveSourceDestination));
        sb.append(", reservedIps=").append(String.valueOf(this.reservedIps));
        sb.append(", isPrivate=").append(String.valueOf(this.isPrivate));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(", nlbIpVersion=").append(String.valueOf((Object)this.nlbIpVersion));
        sb.append(", listeners=").append(String.valueOf(this.listeners));
        sb.append(", backendSets=").append(String.valueOf(this.backendSets));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateNetworkLoadBalancerDetails)) {
            return false;
        }
        CreateNetworkLoadBalancerDetails other = (CreateNetworkLoadBalancerDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.isPreserveSourceDestination, other.isPreserveSourceDestination) && Objects.equals(this.reservedIps, other.reservedIps) && Objects.equals(this.isPrivate, other.isPrivate) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && Objects.equals((Object)this.nlbIpVersion, (Object)other.nlbIpVersion) && Objects.equals(this.listeners, other.listeners) && Objects.equals(this.backendSets, other.backendSets) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.isPreserveSourceDestination == null ? 43 : this.isPreserveSourceDestination.hashCode());
        result = result * 59 + (this.reservedIps == null ? 43 : this.reservedIps.hashCode());
        result = result * 59 + (this.isPrivate == null ? 43 : this.isPrivate.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + (this.nlbIpVersion == null ? 43 : this.nlbIpVersion.hashCode());
        result = result * 59 + (this.listeners == null ? 43 : this.listeners.hashCode());
        result = result * 59 + (this.backendSets == null ? 43 : this.backendSets.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="isPreserveSourceDestination")
        private Boolean isPreserveSourceDestination;
        @JsonProperty(value="reservedIps")
        private List<ReservedIP> reservedIps;
        @JsonProperty(value="isPrivate")
        private Boolean isPrivate;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonProperty(value="nlbIpVersion")
        private NlbIpVersion nlbIpVersion;
        @JsonProperty(value="listeners")
        private Map<String, ListenerDetails> listeners;
        @JsonProperty(value="backendSets")
        private Map<String, BackendSetDetails> backendSets;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder isPreserveSourceDestination(Boolean isPreserveSourceDestination) {
            this.isPreserveSourceDestination = isPreserveSourceDestination;
            this.__explicitlySet__.add("isPreserveSourceDestination");
            return this;
        }

        public Builder reservedIps(List<ReservedIP> reservedIps) {
            this.reservedIps = reservedIps;
            this.__explicitlySet__.add("reservedIps");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.__explicitlySet__.add("isPrivate");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public Builder nlbIpVersion(NlbIpVersion nlbIpVersion) {
            this.nlbIpVersion = nlbIpVersion;
            this.__explicitlySet__.add("nlbIpVersion");
            return this;
        }

        public Builder listeners(Map<String, ListenerDetails> listeners) {
            this.listeners = listeners;
            this.__explicitlySet__.add("listeners");
            return this;
        }

        public Builder backendSets(Map<String, BackendSetDetails> backendSets) {
            this.backendSets = backendSets;
            this.__explicitlySet__.add("backendSets");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateNetworkLoadBalancerDetails build() {
            CreateNetworkLoadBalancerDetails model = new CreateNetworkLoadBalancerDetails(this.compartmentId, this.displayName, this.isPreserveSourceDestination, this.reservedIps, this.isPrivate, this.subnetId, this.networkSecurityGroupIds, this.nlbIpVersion, this.listeners, this.backendSets, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateNetworkLoadBalancerDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isPreserveSourceDestination")) {
                this.isPreserveSourceDestination(model.getIsPreserveSourceDestination());
            }
            if (model.wasPropertyExplicitlySet("reservedIps")) {
                this.reservedIps(model.getReservedIps());
            }
            if (model.wasPropertyExplicitlySet("isPrivate")) {
                this.isPrivate(model.getIsPrivate());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            if (model.wasPropertyExplicitlySet("nlbIpVersion")) {
                this.nlbIpVersion(model.getNlbIpVersion());
            }
            if (model.wasPropertyExplicitlySet("listeners")) {
                this.listeners(model.getListeners());
            }
            if (model.wasPropertyExplicitlySet("backendSets")) {
                this.backendSets(model.getBackendSets());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

