/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackendSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="weight")
    private final Integer weight;
    @JsonProperty(value="isDrain")
    private final Boolean isDrain;
    @JsonProperty(value="isBackup")
    private final Boolean isBackup;
    @JsonProperty(value="isOffline")
    private final Boolean isOffline;

    @Deprecated
    @ConstructorProperties(value={"name", "ipAddress", "targetId", "port", "weight", "isDrain", "isBackup", "isOffline"})
    public BackendSummary(String name, String ipAddress, String targetId, Integer port, Integer weight, Boolean isDrain, Boolean isBackup, Boolean isOffline) {
        this.name = name;
        this.ipAddress = ipAddress;
        this.targetId = targetId;
        this.port = port;
        this.weight = weight;
        this.isDrain = isDrain;
        this.isBackup = isBackup;
        this.isOffline = isOffline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public Boolean getIsDrain() {
        return this.isDrain;
    }

    public Boolean getIsBackup() {
        return this.isBackup;
    }

    public Boolean getIsOffline() {
        return this.isOffline;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackendSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", weight=").append(String.valueOf(this.weight));
        sb.append(", isDrain=").append(String.valueOf(this.isDrain));
        sb.append(", isBackup=").append(String.valueOf(this.isBackup));
        sb.append(", isOffline=").append(String.valueOf(this.isOffline));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackendSummary)) {
            return false;
        }
        BackendSummary other = (BackendSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.port, other.port) && Objects.equals(this.weight, other.weight) && Objects.equals(this.isDrain, other.isDrain) && Objects.equals(this.isBackup, other.isBackup) && Objects.equals(this.isOffline, other.isOffline) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.weight == null ? 43 : this.weight.hashCode());
        result = result * 59 + (this.isDrain == null ? 43 : this.isDrain.hashCode());
        result = result * 59 + (this.isBackup == null ? 43 : this.isBackup.hashCode());
        result = result * 59 + (this.isOffline == null ? 43 : this.isOffline.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="weight")
        private Integer weight;
        @JsonProperty(value="isDrain")
        private Boolean isDrain;
        @JsonProperty(value="isBackup")
        private Boolean isBackup;
        @JsonProperty(value="isOffline")
        private Boolean isOffline;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            this.__explicitlySet__.add("weight");
            return this;
        }

        public Builder isDrain(Boolean isDrain) {
            this.isDrain = isDrain;
            this.__explicitlySet__.add("isDrain");
            return this;
        }

        public Builder isBackup(Boolean isBackup) {
            this.isBackup = isBackup;
            this.__explicitlySet__.add("isBackup");
            return this;
        }

        public Builder isOffline(Boolean isOffline) {
            this.isOffline = isOffline;
            this.__explicitlySet__.add("isOffline");
            return this;
        }

        public BackendSummary build() {
            BackendSummary model = new BackendSummary(this.name, this.ipAddress, this.targetId, this.port, this.weight, this.isDrain, this.isBackup, this.isOffline);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackendSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("weight")) {
                this.weight(model.getWeight());
            }
            if (model.wasPropertyExplicitlySet("isDrain")) {
                this.isDrain(model.getIsDrain());
            }
            if (model.wasPropertyExplicitlySet("isBackup")) {
                this.isBackup(model.getIsBackup());
            }
            if (model.wasPropertyExplicitlySet("isOffline")) {
                this.isOffline(model.getIsOffline());
            }
            return this;
        }
    }
}

