/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackendSetHealth
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="warningStateBackendNames")
    private final List<String> warningStateBackendNames;
    @JsonProperty(value="criticalStateBackendNames")
    private final List<String> criticalStateBackendNames;
    @JsonProperty(value="unknownStateBackendNames")
    private final List<String> unknownStateBackendNames;
    @JsonProperty(value="totalBackendCount")
    private final Integer totalBackendCount;

    @Deprecated
    @ConstructorProperties(value={"status", "warningStateBackendNames", "criticalStateBackendNames", "unknownStateBackendNames", "totalBackendCount"})
    public BackendSetHealth(Status status, List<String> warningStateBackendNames, List<String> criticalStateBackendNames, List<String> unknownStateBackendNames, Integer totalBackendCount) {
        this.status = status;
        this.warningStateBackendNames = warningStateBackendNames;
        this.criticalStateBackendNames = criticalStateBackendNames;
        this.unknownStateBackendNames = unknownStateBackendNames;
        this.totalBackendCount = totalBackendCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<String> getWarningStateBackendNames() {
        return this.warningStateBackendNames;
    }

    public List<String> getCriticalStateBackendNames() {
        return this.criticalStateBackendNames;
    }

    public List<String> getUnknownStateBackendNames() {
        return this.unknownStateBackendNames;
    }

    public Integer getTotalBackendCount() {
        return this.totalBackendCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackendSetHealth(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", warningStateBackendNames=").append(String.valueOf(this.warningStateBackendNames));
        sb.append(", criticalStateBackendNames=").append(String.valueOf(this.criticalStateBackendNames));
        sb.append(", unknownStateBackendNames=").append(String.valueOf(this.unknownStateBackendNames));
        sb.append(", totalBackendCount=").append(String.valueOf(this.totalBackendCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackendSetHealth)) {
            return false;
        }
        BackendSetHealth other = (BackendSetHealth)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.warningStateBackendNames, other.warningStateBackendNames) && Objects.equals(this.criticalStateBackendNames, other.criticalStateBackendNames) && Objects.equals(this.unknownStateBackendNames, other.unknownStateBackendNames) && Objects.equals(this.totalBackendCount, other.totalBackendCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.warningStateBackendNames == null ? 43 : this.warningStateBackendNames.hashCode());
        result = result * 59 + (this.criticalStateBackendNames == null ? 43 : this.criticalStateBackendNames.hashCode());
        result = result * 59 + (this.unknownStateBackendNames == null ? 43 : this.unknownStateBackendNames.hashCode());
        result = result * 59 + (this.totalBackendCount == null ? 43 : this.totalBackendCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Ok("OK"),
        Warning("WARNING"),
        Critical("CRITICAL"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="warningStateBackendNames")
        private List<String> warningStateBackendNames;
        @JsonProperty(value="criticalStateBackendNames")
        private List<String> criticalStateBackendNames;
        @JsonProperty(value="unknownStateBackendNames")
        private List<String> unknownStateBackendNames;
        @JsonProperty(value="totalBackendCount")
        private Integer totalBackendCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder warningStateBackendNames(List<String> warningStateBackendNames) {
            this.warningStateBackendNames = warningStateBackendNames;
            this.__explicitlySet__.add("warningStateBackendNames");
            return this;
        }

        public Builder criticalStateBackendNames(List<String> criticalStateBackendNames) {
            this.criticalStateBackendNames = criticalStateBackendNames;
            this.__explicitlySet__.add("criticalStateBackendNames");
            return this;
        }

        public Builder unknownStateBackendNames(List<String> unknownStateBackendNames) {
            this.unknownStateBackendNames = unknownStateBackendNames;
            this.__explicitlySet__.add("unknownStateBackendNames");
            return this;
        }

        public Builder totalBackendCount(Integer totalBackendCount) {
            this.totalBackendCount = totalBackendCount;
            this.__explicitlySet__.add("totalBackendCount");
            return this;
        }

        public BackendSetHealth build() {
            BackendSetHealth model = new BackendSetHealth(this.status, this.warningStateBackendNames, this.criticalStateBackendNames, this.unknownStateBackendNames, this.totalBackendCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackendSetHealth model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("warningStateBackendNames")) {
                this.warningStateBackendNames(model.getWarningStateBackendNames());
            }
            if (model.wasPropertyExplicitlySet("criticalStateBackendNames")) {
                this.criticalStateBackendNames(model.getCriticalStateBackendNames());
            }
            if (model.wasPropertyExplicitlySet("unknownStateBackendNames")) {
                this.unknownStateBackendNames(model.getUnknownStateBackendNames());
            }
            if (model.wasPropertyExplicitlySet("totalBackendCount")) {
                this.totalBackendCount(model.getTotalBackendCount());
            }
            return this;
        }
    }
}

