/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer;

import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancer;
import com.oracle.bmc.networkloadbalancer.model.BackendSetSummary;
import com.oracle.bmc.networkloadbalancer.model.BackendSummary;
import com.oracle.bmc.networkloadbalancer.model.ListenerSummary;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancerHealthSummary;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancerSummary;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancersPolicySummary;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancersProtocolSummary;
import com.oracle.bmc.networkloadbalancer.model.WorkRequestError;
import com.oracle.bmc.networkloadbalancer.model.WorkRequestLogEntry;
import com.oracle.bmc.networkloadbalancer.model.WorkRequestSummary;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListListenersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancerHealthsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersPoliciesRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersProtocolsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListListenersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancerHealthsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersPoliciesResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersProtocolsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class NetworkLoadBalancerPaginators {
    private final NetworkLoadBalancer client;

    public NetworkLoadBalancerPaginators(NetworkLoadBalancer client) {
        this.client = client;
    }

    public Iterable<ListBackendSetsResponse> listBackendSetsResponseIterator(final ListBackendSetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBackendSetsRequest.Builder>(){

            @Override
            public ListBackendSetsRequest.Builder get() {
                return ListBackendSetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackendSetsResponse, String>(){

            @Override
            public String apply(ListBackendSetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackendSetsRequest.Builder>, ListBackendSetsRequest>(){

            @Override
            public ListBackendSetsRequest apply(RequestBuilderAndToken<ListBackendSetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBackendSetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackendSetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBackendSetsRequest, ListBackendSetsResponse>(){

            @Override
            public ListBackendSetsResponse apply(ListBackendSetsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listBackendSets(request);
            }
        });
    }

    public Iterable<BackendSetSummary> listBackendSetsRecordIterator(final ListBackendSetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBackendSetsRequest.Builder>(){

            @Override
            public ListBackendSetsRequest.Builder get() {
                return ListBackendSetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackendSetsResponse, String>(){

            @Override
            public String apply(ListBackendSetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackendSetsRequest.Builder>, ListBackendSetsRequest>(){

            @Override
            public ListBackendSetsRequest apply(RequestBuilderAndToken<ListBackendSetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBackendSetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackendSetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBackendSetsRequest, ListBackendSetsResponse>(){

            @Override
            public ListBackendSetsResponse apply(ListBackendSetsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listBackendSets(request);
            }
        }, (Function)new Function<ListBackendSetsResponse, List<BackendSetSummary>>(){

            @Override
            public List<BackendSetSummary> apply(ListBackendSetsResponse response) {
                return response.getBackendSetCollection().getItems();
            }
        });
    }

    public Iterable<ListBackendsResponse> listBackendsResponseIterator(final ListBackendsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBackendsRequest.Builder>(){

            @Override
            public ListBackendsRequest.Builder get() {
                return ListBackendsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackendsResponse, String>(){

            @Override
            public String apply(ListBackendsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackendsRequest.Builder>, ListBackendsRequest>(){

            @Override
            public ListBackendsRequest apply(RequestBuilderAndToken<ListBackendsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBackendsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackendsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBackendsRequest, ListBackendsResponse>(){

            @Override
            public ListBackendsResponse apply(ListBackendsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listBackends(request);
            }
        });
    }

    public Iterable<BackendSummary> listBackendsRecordIterator(final ListBackendsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBackendsRequest.Builder>(){

            @Override
            public ListBackendsRequest.Builder get() {
                return ListBackendsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackendsResponse, String>(){

            @Override
            public String apply(ListBackendsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackendsRequest.Builder>, ListBackendsRequest>(){

            @Override
            public ListBackendsRequest apply(RequestBuilderAndToken<ListBackendsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBackendsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackendsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBackendsRequest, ListBackendsResponse>(){

            @Override
            public ListBackendsResponse apply(ListBackendsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listBackends(request);
            }
        }, (Function)new Function<ListBackendsResponse, List<BackendSummary>>(){

            @Override
            public List<BackendSummary> apply(ListBackendsResponse response) {
                return response.getBackendCollection().getItems();
            }
        });
    }

    public Iterable<ListListenersResponse> listListenersResponseIterator(final ListListenersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListListenersRequest.Builder>(){

            @Override
            public ListListenersRequest.Builder get() {
                return ListListenersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListListenersResponse, String>(){

            @Override
            public String apply(ListListenersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListListenersRequest.Builder>, ListListenersRequest>(){

            @Override
            public ListListenersRequest apply(RequestBuilderAndToken<ListListenersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListListenersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListListenersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListListenersRequest, ListListenersResponse>(){

            @Override
            public ListListenersResponse apply(ListListenersRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listListeners(request);
            }
        });
    }

    public Iterable<ListenerSummary> listListenersRecordIterator(final ListListenersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListListenersRequest.Builder>(){

            @Override
            public ListListenersRequest.Builder get() {
                return ListListenersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListListenersResponse, String>(){

            @Override
            public String apply(ListListenersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListListenersRequest.Builder>, ListListenersRequest>(){

            @Override
            public ListListenersRequest apply(RequestBuilderAndToken<ListListenersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListListenersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListListenersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListListenersRequest, ListListenersResponse>(){

            @Override
            public ListListenersResponse apply(ListListenersRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listListeners(request);
            }
        }, (Function)new Function<ListListenersResponse, List<ListenerSummary>>(){

            @Override
            public List<ListenerSummary> apply(ListListenersResponse response) {
                return response.getListenerCollection().getItems();
            }
        });
    }

    public Iterable<ListNetworkLoadBalancerHealthsResponse> listNetworkLoadBalancerHealthsResponseIterator(final ListNetworkLoadBalancerHealthsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkLoadBalancerHealthsRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancerHealthsRequest.Builder get() {
                return ListNetworkLoadBalancerHealthsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancerHealthsResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancerHealthsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancerHealthsRequest.Builder>, ListNetworkLoadBalancerHealthsRequest>(){

            @Override
            public ListNetworkLoadBalancerHealthsRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancerHealthsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancerHealthsRequest, ListNetworkLoadBalancerHealthsResponse>(){

            @Override
            public ListNetworkLoadBalancerHealthsResponse apply(ListNetworkLoadBalancerHealthsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancerHealths(request);
            }
        });
    }

    public Iterable<NetworkLoadBalancerHealthSummary> listNetworkLoadBalancerHealthsRecordIterator(final ListNetworkLoadBalancerHealthsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkLoadBalancerHealthsRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancerHealthsRequest.Builder get() {
                return ListNetworkLoadBalancerHealthsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancerHealthsResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancerHealthsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancerHealthsRequest.Builder>, ListNetworkLoadBalancerHealthsRequest>(){

            @Override
            public ListNetworkLoadBalancerHealthsRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancerHealthsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancerHealthsRequest, ListNetworkLoadBalancerHealthsResponse>(){

            @Override
            public ListNetworkLoadBalancerHealthsResponse apply(ListNetworkLoadBalancerHealthsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancerHealths(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancerHealthsResponse, List<NetworkLoadBalancerHealthSummary>>(){

            @Override
            public List<NetworkLoadBalancerHealthSummary> apply(ListNetworkLoadBalancerHealthsResponse response) {
                return response.getNetworkLoadBalancerHealthCollection().getItems();
            }
        });
    }

    public Iterable<ListNetworkLoadBalancersResponse> listNetworkLoadBalancersResponseIterator(final ListNetworkLoadBalancersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkLoadBalancersRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancersRequest.Builder get() {
                return ListNetworkLoadBalancersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancersRequest.Builder>, ListNetworkLoadBalancersRequest>(){

            @Override
            public ListNetworkLoadBalancersRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancersRequest, ListNetworkLoadBalancersResponse>(){

            @Override
            public ListNetworkLoadBalancersResponse apply(ListNetworkLoadBalancersRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancers(request);
            }
        });
    }

    public Iterable<NetworkLoadBalancerSummary> listNetworkLoadBalancersRecordIterator(final ListNetworkLoadBalancersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkLoadBalancersRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancersRequest.Builder get() {
                return ListNetworkLoadBalancersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancersRequest.Builder>, ListNetworkLoadBalancersRequest>(){

            @Override
            public ListNetworkLoadBalancersRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancersRequest, ListNetworkLoadBalancersResponse>(){

            @Override
            public ListNetworkLoadBalancersResponse apply(ListNetworkLoadBalancersRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancers(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersResponse, List<NetworkLoadBalancerSummary>>(){

            @Override
            public List<NetworkLoadBalancerSummary> apply(ListNetworkLoadBalancersResponse response) {
                return response.getNetworkLoadBalancerCollection().getItems();
            }
        });
    }

    public Iterable<ListNetworkLoadBalancersPoliciesResponse> listNetworkLoadBalancersPoliciesResponseIterator(final ListNetworkLoadBalancersPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkLoadBalancersPoliciesRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancersPoliciesRequest.Builder get() {
                return ListNetworkLoadBalancersPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersPoliciesResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancersPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancersPoliciesRequest.Builder>, ListNetworkLoadBalancersPoliciesRequest>(){

            @Override
            public ListNetworkLoadBalancersPoliciesRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancersPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancersPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancersPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancersPoliciesRequest, ListNetworkLoadBalancersPoliciesResponse>(){

            @Override
            public ListNetworkLoadBalancersPoliciesResponse apply(ListNetworkLoadBalancersPoliciesRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancersPolicies(request);
            }
        });
    }

    public Iterable<NetworkLoadBalancersPolicySummary> listNetworkLoadBalancersPoliciesRecordIterator(final ListNetworkLoadBalancersPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkLoadBalancersPoliciesRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancersPoliciesRequest.Builder get() {
                return ListNetworkLoadBalancersPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersPoliciesResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancersPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancersPoliciesRequest.Builder>, ListNetworkLoadBalancersPoliciesRequest>(){

            @Override
            public ListNetworkLoadBalancersPoliciesRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancersPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancersPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancersPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancersPoliciesRequest, ListNetworkLoadBalancersPoliciesResponse>(){

            @Override
            public ListNetworkLoadBalancersPoliciesResponse apply(ListNetworkLoadBalancersPoliciesRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancersPolicies(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersPoliciesResponse, List<NetworkLoadBalancersPolicySummary>>(){

            @Override
            public List<NetworkLoadBalancersPolicySummary> apply(ListNetworkLoadBalancersPoliciesResponse response) {
                return response.getNetworkLoadBalancersPolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListNetworkLoadBalancersProtocolsResponse> listNetworkLoadBalancersProtocolsResponseIterator(final ListNetworkLoadBalancersProtocolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkLoadBalancersProtocolsRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancersProtocolsRequest.Builder get() {
                return ListNetworkLoadBalancersProtocolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersProtocolsResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancersProtocolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancersProtocolsRequest.Builder>, ListNetworkLoadBalancersProtocolsRequest>(){

            @Override
            public ListNetworkLoadBalancersProtocolsRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancersProtocolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancersProtocolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancersProtocolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancersProtocolsRequest, ListNetworkLoadBalancersProtocolsResponse>(){

            @Override
            public ListNetworkLoadBalancersProtocolsResponse apply(ListNetworkLoadBalancersProtocolsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancersProtocols(request);
            }
        });
    }

    public Iterable<NetworkLoadBalancersProtocolSummary> listNetworkLoadBalancersProtocolsRecordIterator(final ListNetworkLoadBalancersProtocolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkLoadBalancersProtocolsRequest.Builder>(){

            @Override
            public ListNetworkLoadBalancersProtocolsRequest.Builder get() {
                return ListNetworkLoadBalancersProtocolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersProtocolsResponse, String>(){

            @Override
            public String apply(ListNetworkLoadBalancersProtocolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkLoadBalancersProtocolsRequest.Builder>, ListNetworkLoadBalancersProtocolsRequest>(){

            @Override
            public ListNetworkLoadBalancersProtocolsRequest apply(RequestBuilderAndToken<ListNetworkLoadBalancersProtocolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkLoadBalancersProtocolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkLoadBalancersProtocolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkLoadBalancersProtocolsRequest, ListNetworkLoadBalancersProtocolsResponse>(){

            @Override
            public ListNetworkLoadBalancersProtocolsResponse apply(ListNetworkLoadBalancersProtocolsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listNetworkLoadBalancersProtocols(request);
            }
        }, (Function)new Function<ListNetworkLoadBalancersProtocolsResponse, List<NetworkLoadBalancersProtocolSummary>>(){

            @Override
            public List<NetworkLoadBalancersProtocolSummary> apply(ListNetworkLoadBalancersProtocolsResponse response) {
                return response.getNetworkLoadBalancersProtocolCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NetworkLoadBalancerPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

