/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancerAsyncClient;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancerPaginators;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancerWaiters;
import com.oracle.bmc.networkloadbalancer.model.Backend;
import com.oracle.bmc.networkloadbalancer.model.BackendCollection;
import com.oracle.bmc.networkloadbalancer.model.BackendHealth;
import com.oracle.bmc.networkloadbalancer.model.BackendSet;
import com.oracle.bmc.networkloadbalancer.model.BackendSetCollection;
import com.oracle.bmc.networkloadbalancer.model.BackendSetHealth;
import com.oracle.bmc.networkloadbalancer.model.HealthChecker;
import com.oracle.bmc.networkloadbalancer.model.Listener;
import com.oracle.bmc.networkloadbalancer.model.ListenerCollection;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancer;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancerCollection;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancerHealth;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancerHealthCollection;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancersPolicyCollection;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancersProtocolCollection;
import com.oracle.bmc.networkloadbalancer.model.WorkRequest;
import com.oracle.bmc.networkloadbalancer.model.WorkRequestCollection;
import com.oracle.bmc.networkloadbalancer.model.WorkRequestErrorCollection;
import com.oracle.bmc.networkloadbalancer.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.networkloadbalancer.requests.ChangeNetworkLoadBalancerCompartmentRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListListenersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancerHealthsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersPoliciesRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersProtocolsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.networkloadbalancer.responses.ChangeNetworkLoadBalancerCompartmentResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListListenersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancerHealthsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersPoliciesResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersProtocolsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkLoadBalancerClient
extends BaseSyncClient
implements com.oracle.bmc.networkloadbalancer.NetworkLoadBalancer {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NETWORKLOADBALANCER").serviceEndpointPrefix("").serviceEndpointTemplate("https://network-load-balancer-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(NetworkLoadBalancerAsyncClient.class);
    private final NetworkLoadBalancerWaiters waiters;
    private final NetworkLoadBalancerPaginators paginators;

    private NetworkLoadBalancerClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("NetworkLoadBalancer-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new NetworkLoadBalancerWaiters(executorService, this);
        this.paginators = new NetworkLoadBalancerPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeNetworkLoadBalancerCompartmentResponse changeNetworkLoadBalancerCompartment(ChangeNetworkLoadBalancerCompartmentRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNetworkLoadBalancerCompartmentDetails(), "changeNetworkLoadBalancerCompartmentDetails is required");
        return (ChangeNetworkLoadBalancerCompartmentResponse)this.clientCall(request, ChangeNetworkLoadBalancerCompartmentResponse::builder).logger(LOG, "changeNetworkLoadBalancerCompartment").serviceDetails("NetworkLoadBalancer", "ChangeNetworkLoadBalancerCompartment", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/ChangeNetworkLoadBalancerCompartment").method(Method.POST).requestBuilder(ChangeNetworkLoadBalancerCompartmentRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeNetworkLoadBalancerCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeNetworkLoadBalancerCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBackendResponse createBackend(CreateBackendRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBackendDetails(), "createBackendDetails is required");
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (CreateBackendResponse)this.clientCall(request, CreateBackendResponse::builder).logger(LOG, "createBackend").serviceDetails("NetworkLoadBalancer", "CreateBackend", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Backend/CreateBackend").method(Method.POST).requestBuilder(CreateBackendRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackendResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBackendSetResponse createBackendSet(CreateBackendSetRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBackendSetDetails(), "createBackendSetDetails is required");
        return (CreateBackendSetResponse)this.clientCall(request, CreateBackendSetResponse::builder).logger(LOG, "createBackendSet").serviceDetails("NetworkLoadBalancer", "CreateBackendSet", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSet/CreateBackendSet").method(Method.POST).requestBuilder(CreateBackendSetRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBackendSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateListenerResponse createListener(CreateListenerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateListenerDetails(), "createListenerDetails is required");
        return (CreateListenerResponse)this.clientCall(request, CreateListenerResponse::builder).logger(LOG, "createListener").serviceDetails("NetworkLoadBalancer", "CreateListener", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Listener/CreateListener").method(Method.POST).requestBuilder(CreateListenerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("listeners").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateListenerResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", CreateListenerResponse.Builder::eTag).callSync();
    }

    @Override
    public CreateNetworkLoadBalancerResponse createNetworkLoadBalancer(CreateNetworkLoadBalancerRequest request) {
        Objects.requireNonNull(request.getCreateNetworkLoadBalancerDetails(), "createNetworkLoadBalancerDetails is required");
        return (CreateNetworkLoadBalancerResponse)this.clientCall(request, CreateNetworkLoadBalancerResponse::builder).logger(LOG, "createNetworkLoadBalancer").serviceDetails("NetworkLoadBalancer", "CreateNetworkLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/CreateNetworkLoadBalancer").method(Method.POST).requestBuilder(CreateNetworkLoadBalancerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NetworkLoadBalancer.class, CreateNetworkLoadBalancerResponse.Builder::networkLoadBalancer).handleResponseHeaderString("opc-work-request-id", CreateNetworkLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNetworkLoadBalancerResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateNetworkLoadBalancerResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteBackendResponse deleteBackend(DeleteBackendRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (DeleteBackendResponse)this.clientCall(request, DeleteBackendResponse::builder).logger(LOG, "deleteBackend").serviceDetails("NetworkLoadBalancer", "DeleteBackend", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Backend/DeleteBackend").method(Method.DELETE).requestBuilder(DeleteBackendRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackendResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBackendSetResponse deleteBackendSet(DeleteBackendSetRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (DeleteBackendSetResponse)this.clientCall(request, DeleteBackendSetResponse::builder).logger(LOG, "deleteBackendSet").serviceDetails("NetworkLoadBalancer", "DeleteBackendSet", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSet/DeleteBackendSet").method(Method.DELETE).requestBuilder(DeleteBackendSetRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBackendSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return (DeleteListenerResponse)this.clientCall(request, DeleteListenerResponse::builder).logger(LOG, "deleteListener").serviceDetails("NetworkLoadBalancer", "DeleteListener", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Listener/DeleteListener").method(Method.DELETE).requestBuilder(DeleteListenerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteListenerResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", DeleteListenerResponse.Builder::eTag).callSync();
    }

    @Override
    public DeleteNetworkLoadBalancerResponse deleteNetworkLoadBalancer(DeleteNetworkLoadBalancerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        return (DeleteNetworkLoadBalancerResponse)this.clientCall(request, DeleteNetworkLoadBalancerResponse::builder).logger(LOG, "deleteNetworkLoadBalancer").serviceDetails("NetworkLoadBalancer", "DeleteNetworkLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/DeleteNetworkLoadBalancer").method(Method.DELETE).requestBuilder(DeleteNetworkLoadBalancerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNetworkLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNetworkLoadBalancerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBackendResponse getBackend(GetBackendRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (GetBackendResponse)this.clientCall(request, GetBackendResponse::builder).logger(LOG, "getBackend").serviceDetails("NetworkLoadBalancer", "GetBackend", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Backend/GetBackend").method(Method.GET).requestBuilder(GetBackendRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Backend.class, GetBackendResponse.Builder::backend).handleResponseHeaderString("opc-request-id", GetBackendResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetBackendResponse.Builder::etag).callSync();
    }

    @Override
    public GetBackendHealthResponse getBackendHealth(GetBackendHealthRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (GetBackendHealthResponse)this.clientCall(request, GetBackendHealthResponse::builder).logger(LOG, "getBackendHealth").serviceDetails("NetworkLoadBalancer", "GetBackendHealth", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendHealth/GetBackendHealth").method(Method.GET).requestBuilder(GetBackendHealthRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BackendHealth.class, GetBackendHealthResponse.Builder::backendHealth).handleResponseHeaderString("opc-request-id", GetBackendHealthResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBackendSetResponse getBackendSet(GetBackendSetRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (GetBackendSetResponse)this.clientCall(request, GetBackendSetResponse::builder).logger(LOG, "getBackendSet").serviceDetails("NetworkLoadBalancer", "GetBackendSet", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSet/GetBackendSet").method(Method.GET).requestBuilder(GetBackendSetRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(BackendSet.class, GetBackendSetResponse.Builder::backendSet).handleResponseHeaderString("opc-request-id", GetBackendSetResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetBackendSetResponse.Builder::etag).callSync();
    }

    @Override
    public GetBackendSetHealthResponse getBackendSetHealth(GetBackendSetHealthRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (GetBackendSetHealthResponse)this.clientCall(request, GetBackendSetHealthResponse::builder).logger(LOG, "getBackendSetHealth").serviceDetails("NetworkLoadBalancer", "GetBackendSetHealth", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSetHealth/GetBackendSetHealth").method(Method.GET).requestBuilder(GetBackendSetHealthRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BackendSetHealth.class, GetBackendSetHealthResponse.Builder::backendSetHealth).handleResponseHeaderString("opc-request-id", GetBackendSetHealthResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetBackendSetHealthResponse.Builder::etag).callSync();
    }

    @Override
    public GetHealthCheckerResponse getHealthChecker(GetHealthCheckerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (GetHealthCheckerResponse)this.clientCall(request, GetHealthCheckerResponse::builder).logger(LOG, "getHealthChecker").serviceDetails("NetworkLoadBalancer", "GetHealthChecker", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/HealthChecker/GetHealthChecker").method(Method.GET).requestBuilder(GetHealthCheckerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("healthChecker").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(HealthChecker.class, GetHealthCheckerResponse.Builder::healthChecker).handleResponseHeaderString("opc-request-id", GetHealthCheckerResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetHealthCheckerResponse.Builder::etag).callSync();
    }

    @Override
    public GetListenerResponse getListener(GetListenerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return (GetListenerResponse)this.clientCall(request, GetListenerResponse::builder).logger(LOG, "getListener").serviceDetails("NetworkLoadBalancer", "GetListener", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Listener/GetListener").method(Method.GET).requestBuilder(GetListenerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Listener.class, GetListenerResponse.Builder::listener).handleResponseHeaderString("opc-request-id", GetListenerResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetListenerResponse.Builder::etag).callSync();
    }

    @Override
    public GetNetworkLoadBalancerResponse getNetworkLoadBalancer(GetNetworkLoadBalancerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        return (GetNetworkLoadBalancerResponse)this.clientCall(request, GetNetworkLoadBalancerResponse::builder).logger(LOG, "getNetworkLoadBalancer").serviceDetails("NetworkLoadBalancer", "GetNetworkLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/GetNetworkLoadBalancer").method(Method.GET).requestBuilder(GetNetworkLoadBalancerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkLoadBalancer.class, GetNetworkLoadBalancerResponse.Builder::networkLoadBalancer).handleResponseHeaderString("etag", GetNetworkLoadBalancerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkLoadBalancerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetNetworkLoadBalancerHealthResponse getNetworkLoadBalancerHealth(GetNetworkLoadBalancerHealthRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        return (GetNetworkLoadBalancerHealthResponse)this.clientCall(request, GetNetworkLoadBalancerHealthResponse::builder).logger(LOG, "getNetworkLoadBalancerHealth").serviceDetails("NetworkLoadBalancer", "GetNetworkLoadBalancerHealth", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancerHealth/GetNetworkLoadBalancerHealth").method(Method.GET).requestBuilder(GetNetworkLoadBalancerHealthRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("health").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkLoadBalancerHealth.class, GetNetworkLoadBalancerHealthResponse.Builder::networkLoadBalancerHealth).handleResponseHeaderString("opc-request-id", GetNetworkLoadBalancerHealthResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("NetworkLoadBalancer", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200501").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListBackendSetsResponse listBackendSets(ListBackendSetsRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListBackendSetsResponse)this.clientCall(request, ListBackendSetsResponse::builder).logger(LOG, "listBackendSets").serviceDetails("NetworkLoadBalancer", "ListBackendSets", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSetSummary/ListBackendSets").method(Method.GET).requestBuilder(ListBackendSetsRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(BackendSetCollection.class, ListBackendSetsResponse.Builder::backendSetCollection).handleResponseHeaderString("opc-request-id", ListBackendSetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBackendSetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBackendsResponse listBackends(ListBackendsRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (ListBackendsResponse)this.clientCall(request, ListBackendsResponse::builder).logger(LOG, "listBackends").serviceDetails("NetworkLoadBalancer", "ListBackends", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSummary/ListBackends").method(Method.GET).requestBuilder(ListBackendsRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(BackendCollection.class, ListBackendsResponse.Builder::backendCollection).handleResponseHeaderString("opc-request-id", ListBackendsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBackendsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListListenersResponse listListeners(ListListenersRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        return (ListListenersResponse)this.clientCall(request, ListListenersResponse::builder).logger(LOG, "listListeners").serviceDetails("NetworkLoadBalancer", "ListListeners", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/ListenerSummary/ListListeners").method(Method.GET).requestBuilder(ListListenersRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("listeners").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(ListenerCollection.class, ListListenersResponse.Builder::listenerCollection).handleResponseHeaderString("opc-request-id", ListListenersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListListenersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListNetworkLoadBalancerHealthsResponse listNetworkLoadBalancerHealths(ListNetworkLoadBalancerHealthsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNetworkLoadBalancerHealthsResponse)this.clientCall(request, ListNetworkLoadBalancerHealthsResponse::builder).logger(LOG, "listNetworkLoadBalancerHealths").serviceDetails("NetworkLoadBalancer", "ListNetworkLoadBalancerHealths", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancerHealth/ListNetworkLoadBalancerHealths").method(Method.GET).requestBuilder(ListNetworkLoadBalancerHealthsRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam("health").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkLoadBalancerHealthCollection.class, ListNetworkLoadBalancerHealthsResponse.Builder::networkLoadBalancerHealthCollection).handleResponseHeaderString("opc-next-page", ListNetworkLoadBalancerHealthsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNetworkLoadBalancerHealthsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListNetworkLoadBalancersResponse listNetworkLoadBalancers(ListNetworkLoadBalancersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNetworkLoadBalancersResponse)this.clientCall(request, ListNetworkLoadBalancersResponse::builder).logger(LOG, "listNetworkLoadBalancers").serviceDetails("NetworkLoadBalancer", "ListNetworkLoadBalancers", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/ListNetworkLoadBalancers").method(Method.GET).requestBuilder(ListNetworkLoadBalancersRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkLoadBalancerCollection.class, ListNetworkLoadBalancersResponse.Builder::networkLoadBalancerCollection).handleResponseHeaderString("opc-request-id", ListNetworkLoadBalancersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNetworkLoadBalancersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListNetworkLoadBalancersPoliciesResponse listNetworkLoadBalancersPolicies(ListNetworkLoadBalancersPoliciesRequest request) {
        return (ListNetworkLoadBalancersPoliciesResponse)this.clientCall(request, ListNetworkLoadBalancersPoliciesResponse::builder).logger(LOG, "listNetworkLoadBalancersPolicies").serviceDetails("NetworkLoadBalancer", "ListNetworkLoadBalancersPolicies", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancingPolicy/ListNetworkLoadBalancersPolicies").method(Method.GET).requestBuilder(ListNetworkLoadBalancersPoliciesRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancersPolicies").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkLoadBalancersPolicyCollection.class, ListNetworkLoadBalancersPoliciesResponse.Builder::networkLoadBalancersPolicyCollection).handleResponseHeaderString("opc-next-page", ListNetworkLoadBalancersPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNetworkLoadBalancersPoliciesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListNetworkLoadBalancersProtocolsResponse listNetworkLoadBalancersProtocols(ListNetworkLoadBalancersProtocolsRequest request) {
        return (ListNetworkLoadBalancersProtocolsResponse)this.clientCall(request, ListNetworkLoadBalancersProtocolsResponse::builder).logger(LOG, "listNetworkLoadBalancersProtocols").serviceDetails("NetworkLoadBalancer", "ListNetworkLoadBalancersProtocols", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/ListenerProtocols/ListNetworkLoadBalancersProtocols").method(Method.GET).requestBuilder(ListNetworkLoadBalancersProtocolsRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancersProtocols").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkLoadBalancersProtocolCollection.class, ListNetworkLoadBalancersProtocolsResponse.Builder::networkLoadBalancersProtocolCollection).handleResponseHeaderString("opc-next-page", ListNetworkLoadBalancersProtocolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNetworkLoadBalancersProtocolsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("NetworkLoadBalancer", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200501").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("NetworkLoadBalancer", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200501").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("NetworkLoadBalancer", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200501").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBackendResponse updateBackend(UpdateBackendRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBackendDetails(), "updateBackendDetails is required");
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        return (UpdateBackendResponse)this.clientCall(request, UpdateBackendResponse::builder).logger(LOG, "updateBackend").serviceDetails("NetworkLoadBalancer", "UpdateBackend", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Backend/UpdateBackend").method(Method.PUT).requestBuilder(UpdateBackendRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("backends").appendPathParam(request.getBackendName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBackendResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBackendResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBackendSetResponse updateBackendSet(UpdateBackendSetRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBackendSetDetails(), "updateBackendSetDetails is required");
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (UpdateBackendSetResponse)this.clientCall(request, UpdateBackendSetResponse::builder).logger(LOG, "updateBackendSet").serviceDetails("NetworkLoadBalancer", "UpdateBackendSet", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/BackendSet/UpdateBackendSet").method(Method.PUT).requestBuilder(UpdateBackendSetRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBackendSetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBackendSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateHealthCheckerResponse updateHealthChecker(UpdateHealthCheckerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHealthCheckerDetails(), "updateHealthCheckerDetails is required");
        Validate.notBlank((String)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        return (UpdateHealthCheckerResponse)this.clientCall(request, UpdateHealthCheckerResponse::builder).logger(LOG, "updateHealthChecker").serviceDetails("NetworkLoadBalancer", "UpdateHealthChecker", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/HealthChecker/UpdateHealthChecker").method(Method.PUT).requestBuilder(UpdateHealthCheckerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("backendSets").appendPathParam(request.getBackendSetName()).appendPathParam("healthChecker").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHealthCheckerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHealthCheckerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateListenerDetails(), "updateListenerDetails is required");
        Validate.notBlank((String)request.getListenerName(), (String)"listenerName must not be blank", (Object[])new Object[0]);
        return (UpdateListenerResponse)this.clientCall(request, UpdateListenerResponse::builder).logger(LOG, "updateListener").serviceDetails("NetworkLoadBalancer", "UpdateListener", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/Listener/UpdateListener").method(Method.PUT).requestBuilder(UpdateListenerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("listeners").appendPathParam(request.getListenerName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateListenerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateListenerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNetworkLoadBalancerResponse updateNetworkLoadBalancer(UpdateNetworkLoadBalancerRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkLoadBalancerDetails(), "updateNetworkLoadBalancerDetails is required");
        return (UpdateNetworkLoadBalancerResponse)this.clientCall(request, UpdateNetworkLoadBalancerResponse::builder).logger(LOG, "updateNetworkLoadBalancer").serviceDetails("NetworkLoadBalancer", "UpdateNetworkLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/UpdateNetworkLoadBalancer").method(Method.PUT).requestBuilder(UpdateNetworkLoadBalancerRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkLoadBalancerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkLoadBalancerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNetworkSecurityGroupsResponse updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request) {
        Validate.notBlank((String)request.getNetworkLoadBalancerId(), (String)"networkLoadBalancerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkSecurityGroupsDetails(), "updateNetworkSecurityGroupsDetails is required");
        return (UpdateNetworkSecurityGroupsResponse)this.clientCall(request, UpdateNetworkSecurityGroupsResponse::builder).logger(LOG, "updateNetworkSecurityGroups").serviceDetails("NetworkLoadBalancer", "UpdateNetworkSecurityGroups", "https://docs.oracle.com/iaas/api/#/en/networkloadbalancer/20200501/NetworkLoadBalancer/UpdateNetworkSecurityGroups").method(Method.PUT).requestBuilder(UpdateNetworkSecurityGroupsRequest::builder).basePath("/20200501").appendPathParam("networkLoadBalancers").appendPathParam(request.getNetworkLoadBalancerId()).appendPathParam("networkSecurityGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkSecurityGroupsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkSecurityGroupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public NetworkLoadBalancerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public NetworkLoadBalancerPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public NetworkLoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)NetworkLoadBalancerClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(NetworkLoadBalancerClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)NetworkLoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)NetworkLoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)NetworkLoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)NetworkLoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NetworkLoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NetworkLoadBalancerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NetworkLoadBalancerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public NetworkLoadBalancerClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new NetworkLoadBalancerClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

