/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNetworkFirewallPolicyRequest
extends BmcRequest<Void> {
    private String networkFirewallPolicyId;
    private String opcRequestId;

    public String getNetworkFirewallPolicyId() {
        return this.networkFirewallPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().networkFirewallPolicyId(this.networkFirewallPolicyId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkFirewallPolicyId=").append(String.valueOf(this.networkFirewallPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkFirewallPolicyRequest)) {
            return false;
        }
        GetNetworkFirewallPolicyRequest other = (GetNetworkFirewallPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkFirewallPolicyId, other.networkFirewallPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkFirewallPolicyId == null ? 43 : this.networkFirewallPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkFirewallPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkFirewallPolicyId = null;
        private String opcRequestId = null;

        public Builder networkFirewallPolicyId(String networkFirewallPolicyId) {
            this.networkFirewallPolicyId = networkFirewallPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkFirewallPolicyRequest o) {
            this.networkFirewallPolicyId(o.getNetworkFirewallPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkFirewallPolicyRequest build() {
            GetNetworkFirewallPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNetworkFirewallPolicyRequest buildWithoutInvocationCallback() {
            GetNetworkFirewallPolicyRequest request = new GetNetworkFirewallPolicyRequest();
            request.networkFirewallPolicyId = this.networkFirewallPolicyId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

