/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.networkfirewall.model.MappedSecret;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source")
@JsonFilter(value="explicitlySetFilter")
public final class VaultMappedSecret
extends MappedSecret {
    @JsonProperty(value="vaultSecretId")
    private final String vaultSecretId;
    @JsonProperty(value="versionNumber")
    private final Integer versionNumber;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VaultMappedSecret(MappedSecret.Type type, String vaultSecretId, Integer versionNumber) {
        super(type);
        this.vaultSecretId = vaultSecretId;
        this.versionNumber = versionNumber;
    }

    public String getVaultSecretId() {
        return this.vaultSecretId;
    }

    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VaultMappedSecret(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vaultSecretId=").append(String.valueOf(this.vaultSecretId));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VaultMappedSecret)) {
            return false;
        }
        VaultMappedSecret other = (VaultMappedSecret)((Object)o);
        return Objects.equals(this.vaultSecretId, other.vaultSecretId) && Objects.equals(this.versionNumber, other.versionNumber) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vaultSecretId == null ? 43 : this.vaultSecretId.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private MappedSecret.Type type;
        @JsonProperty(value="vaultSecretId")
        private String vaultSecretId;
        @JsonProperty(value="versionNumber")
        private Integer versionNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(MappedSecret.Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder vaultSecretId(String vaultSecretId) {
            this.vaultSecretId = vaultSecretId;
            this.__explicitlySet__.add("vaultSecretId");
            return this;
        }

        public Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public VaultMappedSecret build() {
            VaultMappedSecret model = new VaultMappedSecret(this.type, this.vaultSecretId, this.versionNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VaultMappedSecret model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("vaultSecretId")) {
                this.vaultSecretId(model.getVaultSecretId());
            }
            if (model.wasPropertyExplicitlySet("versionNumber")) {
                this.versionNumber(model.getVersionNumber());
            }
            return this;
        }
    }
}

