/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.networkfirewall.model.Application;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class UdpApplication
extends Application {
    @JsonProperty(value="minimumPort")
    private final Integer minimumPort;
    @JsonProperty(value="maximumPort")
    private final Integer maximumPort;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UdpApplication(Integer minimumPort, Integer maximumPort) {
        this.minimumPort = minimumPort;
        this.maximumPort = maximumPort;
    }

    public Integer getMinimumPort() {
        return this.minimumPort;
    }

    public Integer getMaximumPort() {
        return this.maximumPort;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UdpApplication(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", minimumPort=").append(String.valueOf(this.minimumPort));
        sb.append(", maximumPort=").append(String.valueOf(this.maximumPort));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UdpApplication)) {
            return false;
        }
        UdpApplication other = (UdpApplication)((Object)o);
        return Objects.equals(this.minimumPort, other.minimumPort) && Objects.equals(this.maximumPort, other.maximumPort) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.minimumPort == null ? 43 : this.minimumPort.hashCode());
        result = result * 59 + (this.maximumPort == null ? 43 : this.maximumPort.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="minimumPort")
        private Integer minimumPort;
        @JsonProperty(value="maximumPort")
        private Integer maximumPort;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder minimumPort(Integer minimumPort) {
            this.minimumPort = minimumPort;
            this.__explicitlySet__.add("minimumPort");
            return this;
        }

        public Builder maximumPort(Integer maximumPort) {
            this.maximumPort = maximumPort;
            this.__explicitlySet__.add("maximumPort");
            return this;
        }

        public UdpApplication build() {
            UdpApplication model = new UdpApplication(this.minimumPort, this.maximumPort);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UdpApplication model) {
            if (model.wasPropertyExplicitlySet("minimumPort")) {
                this.minimumPort(model.getMinimumPort());
            }
            if (model.wasPropertyExplicitlySet("maximumPort")) {
                this.maximumPort(model.getMaximumPort());
            }
            return this;
        }
    }
}

