/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityRuleMatchCriteria
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sources")
    private final List<String> sources;
    @JsonProperty(value="destinations")
    private final List<String> destinations;
    @JsonProperty(value="applications")
    private final List<String> applications;
    @JsonProperty(value="urls")
    private final List<String> urls;

    @Deprecated
    @ConstructorProperties(value={"sources", "destinations", "applications", "urls"})
    public SecurityRuleMatchCriteria(List<String> sources, List<String> destinations, List<String> applications, List<String> urls) {
        this.sources = sources;
        this.destinations = destinations;
        this.applications = applications;
        this.urls = urls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getSources() {
        return this.sources;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public List<String> getApplications() {
        return this.applications;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityRuleMatchCriteria(");
        sb.append("super=").append(super.toString());
        sb.append("sources=").append(String.valueOf(this.sources));
        sb.append(", destinations=").append(String.valueOf(this.destinations));
        sb.append(", applications=").append(String.valueOf(this.applications));
        sb.append(", urls=").append(String.valueOf(this.urls));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityRuleMatchCriteria)) {
            return false;
        }
        SecurityRuleMatchCriteria other = (SecurityRuleMatchCriteria)((Object)o);
        return Objects.equals(this.sources, other.sources) && Objects.equals(this.destinations, other.destinations) && Objects.equals(this.applications, other.applications) && Objects.equals(this.urls, other.urls) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sources == null ? 43 : this.sources.hashCode());
        result = result * 59 + (this.destinations == null ? 43 : this.destinations.hashCode());
        result = result * 59 + (this.applications == null ? 43 : this.applications.hashCode());
        result = result * 59 + (this.urls == null ? 43 : this.urls.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sources")
        private List<String> sources;
        @JsonProperty(value="destinations")
        private List<String> destinations;
        @JsonProperty(value="applications")
        private List<String> applications;
        @JsonProperty(value="urls")
        private List<String> urls;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sources(List<String> sources) {
            this.sources = sources;
            this.__explicitlySet__.add("sources");
            return this;
        }

        public Builder destinations(List<String> destinations) {
            this.destinations = destinations;
            this.__explicitlySet__.add("destinations");
            return this;
        }

        public Builder applications(List<String> applications) {
            this.applications = applications;
            this.__explicitlySet__.add("applications");
            return this;
        }

        public Builder urls(List<String> urls) {
            this.urls = urls;
            this.__explicitlySet__.add("urls");
            return this;
        }

        public SecurityRuleMatchCriteria build() {
            SecurityRuleMatchCriteria model = new SecurityRuleMatchCriteria(this.sources, this.destinations, this.applications, this.urls);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityRuleMatchCriteria model) {
            if (model.wasPropertyExplicitlySet("sources")) {
                this.sources(model.getSources());
            }
            if (model.wasPropertyExplicitlySet("destinations")) {
                this.destinations(model.getDestinations());
            }
            if (model.wasPropertyExplicitlySet("applications")) {
                this.applications(model.getApplications());
            }
            if (model.wasPropertyExplicitlySet("urls")) {
                this.urls(model.getUrls());
            }
            return this;
        }
    }
}

