/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.networkfirewall.model.SecurityRuleMatchCriteria;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="condition")
    private final SecurityRuleMatchCriteria condition;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="inspection")
    private final Inspection inspection;

    @Deprecated
    @ConstructorProperties(value={"name", "condition", "action", "inspection"})
    public SecurityRule(String name, SecurityRuleMatchCriteria condition, Action action, Inspection inspection) {
        this.name = name;
        this.condition = condition;
        this.action = action;
        this.inspection = inspection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public SecurityRuleMatchCriteria getCondition() {
        return this.condition;
    }

    public Action getAction() {
        return this.action;
    }

    public Inspection getInspection() {
        return this.inspection;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityRule(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", condition=").append(String.valueOf((Object)this.condition));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", inspection=").append(String.valueOf((Object)this.inspection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityRule)) {
            return false;
        }
        SecurityRule other = (SecurityRule)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.condition, (Object)other.condition) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.inspection, (Object)other.inspection) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.inspection == null ? 43 : this.inspection.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Inspection implements BmcEnum
    {
        IntrusionDetection("INTRUSION_DETECTION"),
        IntrusionPrevention("INTRUSION_PREVENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Inspection> map;

        private Inspection(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Inspection create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Inspection', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Inspection.class);
            map = new HashMap<String, Inspection>();
            for (Inspection v : Inspection.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        Allow("ALLOW"),
        Drop("DROP"),
        Reject("REJECT"),
        Inspect("INSPECT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="condition")
        private SecurityRuleMatchCriteria condition;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="inspection")
        private Inspection inspection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder condition(SecurityRuleMatchCriteria condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder inspection(Inspection inspection) {
            this.inspection = inspection;
            this.__explicitlySet__.add("inspection");
            return this;
        }

        public SecurityRule build() {
            SecurityRule model = new SecurityRule(this.name, this.condition, this.action, this.inspection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityRule model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("inspection")) {
                this.inspection(model.getInspection());
            }
            return this;
        }
    }
}

