/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.networkfirewall.model.Application;
import com.oracle.bmc.networkfirewall.model.DecryptionProfile;
import com.oracle.bmc.networkfirewall.model.DecryptionRule;
import com.oracle.bmc.networkfirewall.model.LifecycleState;
import com.oracle.bmc.networkfirewall.model.MappedSecret;
import com.oracle.bmc.networkfirewall.model.SecurityRule;
import com.oracle.bmc.networkfirewall.model.UrlPattern;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkFirewallPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="mappedSecrets")
    private final Map<String, MappedSecret> mappedSecrets;
    @JsonProperty(value="applicationLists")
    private final Map<String, List<Application>> applicationLists;
    @JsonProperty(value="urlLists")
    private final Map<String, List<UrlPattern>> urlLists;
    @JsonProperty(value="ipAddressLists")
    private final Map<String, List<String>> ipAddressLists;
    @JsonProperty(value="securityRules")
    private final List<SecurityRule> securityRules;
    @JsonProperty(value="decryptionRules")
    private final List<DecryptionRule> decryptionRules;
    @JsonProperty(value="decryptionProfiles")
    private final Map<String, DecryptionProfile> decryptionProfiles;
    @JsonProperty(value="isFirewallAttached")
    private final Boolean isFirewallAttached;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "mappedSecrets", "applicationLists", "urlLists", "ipAddressLists", "securityRules", "decryptionRules", "decryptionProfiles", "isFirewallAttached", "freeformTags", "definedTags", "systemTags"})
    public NetworkFirewallPolicy(String id, String compartmentId, String displayName, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, Map<String, MappedSecret> mappedSecrets, Map<String, List<Application>> applicationLists, Map<String, List<UrlPattern>> urlLists, Map<String, List<String>> ipAddressLists, List<SecurityRule> securityRules, List<DecryptionRule> decryptionRules, Map<String, DecryptionProfile> decryptionProfiles, Boolean isFirewallAttached, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.mappedSecrets = mappedSecrets;
        this.applicationLists = applicationLists;
        this.urlLists = urlLists;
        this.ipAddressLists = ipAddressLists;
        this.securityRules = securityRules;
        this.decryptionRules = decryptionRules;
        this.decryptionProfiles = decryptionProfiles;
        this.isFirewallAttached = isFirewallAttached;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, MappedSecret> getMappedSecrets() {
        return this.mappedSecrets;
    }

    public Map<String, List<Application>> getApplicationLists() {
        return this.applicationLists;
    }

    public Map<String, List<UrlPattern>> getUrlLists() {
        return this.urlLists;
    }

    public Map<String, List<String>> getIpAddressLists() {
        return this.ipAddressLists;
    }

    public List<SecurityRule> getSecurityRules() {
        return this.securityRules;
    }

    public List<DecryptionRule> getDecryptionRules() {
        return this.decryptionRules;
    }

    public Map<String, DecryptionProfile> getDecryptionProfiles() {
        return this.decryptionProfiles;
    }

    public Boolean getIsFirewallAttached() {
        return this.isFirewallAttached;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkFirewallPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", mappedSecrets=").append(String.valueOf(this.mappedSecrets));
        sb.append(", applicationLists=").append(String.valueOf(this.applicationLists));
        sb.append(", urlLists=").append(String.valueOf(this.urlLists));
        sb.append(", ipAddressLists=").append(String.valueOf(this.ipAddressLists));
        sb.append(", securityRules=").append(String.valueOf(this.securityRules));
        sb.append(", decryptionRules=").append(String.valueOf(this.decryptionRules));
        sb.append(", decryptionProfiles=").append(String.valueOf(this.decryptionProfiles));
        sb.append(", isFirewallAttached=").append(String.valueOf(this.isFirewallAttached));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkFirewallPolicy)) {
            return false;
        }
        NetworkFirewallPolicy other = (NetworkFirewallPolicy)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.mappedSecrets, other.mappedSecrets) && Objects.equals(this.applicationLists, other.applicationLists) && Objects.equals(this.urlLists, other.urlLists) && Objects.equals(this.ipAddressLists, other.ipAddressLists) && Objects.equals(this.securityRules, other.securityRules) && Objects.equals(this.decryptionRules, other.decryptionRules) && Objects.equals(this.decryptionProfiles, other.decryptionProfiles) && Objects.equals(this.isFirewallAttached, other.isFirewallAttached) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.mappedSecrets == null ? 43 : this.mappedSecrets.hashCode());
        result = result * 59 + (this.applicationLists == null ? 43 : this.applicationLists.hashCode());
        result = result * 59 + (this.urlLists == null ? 43 : this.urlLists.hashCode());
        result = result * 59 + (this.ipAddressLists == null ? 43 : this.ipAddressLists.hashCode());
        result = result * 59 + (this.securityRules == null ? 43 : this.securityRules.hashCode());
        result = result * 59 + (this.decryptionRules == null ? 43 : this.decryptionRules.hashCode());
        result = result * 59 + (this.decryptionProfiles == null ? 43 : this.decryptionProfiles.hashCode());
        result = result * 59 + (this.isFirewallAttached == null ? 43 : this.isFirewallAttached.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="mappedSecrets")
        private Map<String, MappedSecret> mappedSecrets;
        @JsonProperty(value="applicationLists")
        private Map<String, List<Application>> applicationLists;
        @JsonProperty(value="urlLists")
        private Map<String, List<UrlPattern>> urlLists;
        @JsonProperty(value="ipAddressLists")
        private Map<String, List<String>> ipAddressLists;
        @JsonProperty(value="securityRules")
        private List<SecurityRule> securityRules;
        @JsonProperty(value="decryptionRules")
        private List<DecryptionRule> decryptionRules;
        @JsonProperty(value="decryptionProfiles")
        private Map<String, DecryptionProfile> decryptionProfiles;
        @JsonProperty(value="isFirewallAttached")
        private Boolean isFirewallAttached;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder mappedSecrets(Map<String, MappedSecret> mappedSecrets) {
            this.mappedSecrets = mappedSecrets;
            this.__explicitlySet__.add("mappedSecrets");
            return this;
        }

        public Builder applicationLists(Map<String, List<Application>> applicationLists) {
            this.applicationLists = applicationLists;
            this.__explicitlySet__.add("applicationLists");
            return this;
        }

        public Builder urlLists(Map<String, List<UrlPattern>> urlLists) {
            this.urlLists = urlLists;
            this.__explicitlySet__.add("urlLists");
            return this;
        }

        public Builder ipAddressLists(Map<String, List<String>> ipAddressLists) {
            this.ipAddressLists = ipAddressLists;
            this.__explicitlySet__.add("ipAddressLists");
            return this;
        }

        public Builder securityRules(List<SecurityRule> securityRules) {
            this.securityRules = securityRules;
            this.__explicitlySet__.add("securityRules");
            return this;
        }

        public Builder decryptionRules(List<DecryptionRule> decryptionRules) {
            this.decryptionRules = decryptionRules;
            this.__explicitlySet__.add("decryptionRules");
            return this;
        }

        public Builder decryptionProfiles(Map<String, DecryptionProfile> decryptionProfiles) {
            this.decryptionProfiles = decryptionProfiles;
            this.__explicitlySet__.add("decryptionProfiles");
            return this;
        }

        public Builder isFirewallAttached(Boolean isFirewallAttached) {
            this.isFirewallAttached = isFirewallAttached;
            this.__explicitlySet__.add("isFirewallAttached");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public NetworkFirewallPolicy build() {
            NetworkFirewallPolicy model = new NetworkFirewallPolicy(this.id, this.compartmentId, this.displayName, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.mappedSecrets, this.applicationLists, this.urlLists, this.ipAddressLists, this.securityRules, this.decryptionRules, this.decryptionProfiles, this.isFirewallAttached, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkFirewallPolicy model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("mappedSecrets")) {
                this.mappedSecrets(model.getMappedSecrets());
            }
            if (model.wasPropertyExplicitlySet("applicationLists")) {
                this.applicationLists(model.getApplicationLists());
            }
            if (model.wasPropertyExplicitlySet("urlLists")) {
                this.urlLists(model.getUrlLists());
            }
            if (model.wasPropertyExplicitlySet("ipAddressLists")) {
                this.ipAddressLists(model.getIpAddressLists());
            }
            if (model.wasPropertyExplicitlySet("securityRules")) {
                this.securityRules(model.getSecurityRules());
            }
            if (model.wasPropertyExplicitlySet("decryptionRules")) {
                this.decryptionRules(model.getDecryptionRules());
            }
            if (model.wasPropertyExplicitlySet("decryptionProfiles")) {
                this.decryptionProfiles(model.getDecryptionProfiles());
            }
            if (model.wasPropertyExplicitlySet("isFirewallAttached")) {
                this.isFirewallAttached(model.getIsFirewallAttached());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

