/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall;

import com.oracle.bmc.networkfirewall.NetworkFirewall;
import com.oracle.bmc.networkfirewall.model.LifecycleState;
import com.oracle.bmc.networkfirewall.requests.GetNetworkFirewallPolicyRequest;
import com.oracle.bmc.networkfirewall.requests.GetNetworkFirewallRequest;
import com.oracle.bmc.networkfirewall.requests.GetWorkRequestRequest;
import com.oracle.bmc.networkfirewall.responses.GetNetworkFirewallPolicyResponse;
import com.oracle.bmc.networkfirewall.responses.GetNetworkFirewallResponse;
import com.oracle.bmc.networkfirewall.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class NetworkFirewallWaiters {
    private final ExecutorService executorService;
    private final NetworkFirewall client;

    public NetworkFirewallWaiters(ExecutorService executorService, NetworkFirewall client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetNetworkFirewallRequest, GetNetworkFirewallResponse> forNetworkFirewall(GetNetworkFirewallRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkFirewall(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNetworkFirewallRequest, GetNetworkFirewallResponse> forNetworkFirewall(GetNetworkFirewallRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNetworkFirewall(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNetworkFirewallRequest, GetNetworkFirewallResponse> forNetworkFirewall(GetNetworkFirewallRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkFirewall(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNetworkFirewallRequest, GetNetworkFirewallResponse> forNetworkFirewall(BmcGenericWaiter waiter, GetNetworkFirewallRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNetworkFirewallRequest, GetNetworkFirewallResponse>(){

            @Override
            public GetNetworkFirewallResponse apply(GetNetworkFirewallRequest request) {
                return NetworkFirewallWaiters.this.client.getNetworkFirewall(request);
            }
        }, (Predicate)new Predicate<GetNetworkFirewallResponse>(){

            @Override
            public boolean test(GetNetworkFirewallResponse response) {
                return targetStatesSet.contains((Object)response.getNetworkFirewall().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetNetworkFirewallPolicyRequest, GetNetworkFirewallPolicyResponse> forNetworkFirewallPolicy(GetNetworkFirewallPolicyRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkFirewallPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNetworkFirewallPolicyRequest, GetNetworkFirewallPolicyResponse> forNetworkFirewallPolicy(GetNetworkFirewallPolicyRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNetworkFirewallPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNetworkFirewallPolicyRequest, GetNetworkFirewallPolicyResponse> forNetworkFirewallPolicy(GetNetworkFirewallPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkFirewallPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNetworkFirewallPolicyRequest, GetNetworkFirewallPolicyResponse> forNetworkFirewallPolicy(BmcGenericWaiter waiter, GetNetworkFirewallPolicyRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNetworkFirewallPolicyRequest, GetNetworkFirewallPolicyResponse>(){

            @Override
            public GetNetworkFirewallPolicyResponse apply(GetNetworkFirewallPolicyRequest request) {
                return NetworkFirewallWaiters.this.client.getNetworkFirewallPolicy(request);
            }
        }, (Predicate)new Predicate<GetNetworkFirewallPolicyResponse>(){

            @Override
            public boolean test(GetNetworkFirewallPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getNetworkFirewallPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return NetworkFirewallWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

