/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall;

import com.oracle.bmc.networkfirewall.NetworkFirewall;
import com.oracle.bmc.networkfirewall.model.NetworkFirewallPolicySummary;
import com.oracle.bmc.networkfirewall.model.NetworkFirewallSummary;
import com.oracle.bmc.networkfirewall.model.WorkRequestError;
import com.oracle.bmc.networkfirewall.model.WorkRequestLogEntry;
import com.oracle.bmc.networkfirewall.model.WorkRequestSummary;
import com.oracle.bmc.networkfirewall.requests.ListNetworkFirewallPoliciesRequest;
import com.oracle.bmc.networkfirewall.requests.ListNetworkFirewallsRequest;
import com.oracle.bmc.networkfirewall.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.networkfirewall.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.networkfirewall.requests.ListWorkRequestsRequest;
import com.oracle.bmc.networkfirewall.responses.ListNetworkFirewallPoliciesResponse;
import com.oracle.bmc.networkfirewall.responses.ListNetworkFirewallsResponse;
import com.oracle.bmc.networkfirewall.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.networkfirewall.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.networkfirewall.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class NetworkFirewallPaginators {
    private final NetworkFirewall client;

    public NetworkFirewallPaginators(NetworkFirewall client) {
        this.client = client;
    }

    public Iterable<ListNetworkFirewallPoliciesResponse> listNetworkFirewallPoliciesResponseIterator(final ListNetworkFirewallPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkFirewallPoliciesRequest.Builder>(){

            @Override
            public ListNetworkFirewallPoliciesRequest.Builder get() {
                return ListNetworkFirewallPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkFirewallPoliciesResponse, String>(){

            @Override
            public String apply(ListNetworkFirewallPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkFirewallPoliciesRequest.Builder>, ListNetworkFirewallPoliciesRequest>(){

            @Override
            public ListNetworkFirewallPoliciesRequest apply(RequestBuilderAndToken<ListNetworkFirewallPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkFirewallPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkFirewallPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkFirewallPoliciesRequest, ListNetworkFirewallPoliciesResponse>(){

            @Override
            public ListNetworkFirewallPoliciesResponse apply(ListNetworkFirewallPoliciesRequest request) {
                return NetworkFirewallPaginators.this.client.listNetworkFirewallPolicies(request);
            }
        });
    }

    public Iterable<NetworkFirewallPolicySummary> listNetworkFirewallPoliciesRecordIterator(final ListNetworkFirewallPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkFirewallPoliciesRequest.Builder>(){

            @Override
            public ListNetworkFirewallPoliciesRequest.Builder get() {
                return ListNetworkFirewallPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkFirewallPoliciesResponse, String>(){

            @Override
            public String apply(ListNetworkFirewallPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkFirewallPoliciesRequest.Builder>, ListNetworkFirewallPoliciesRequest>(){

            @Override
            public ListNetworkFirewallPoliciesRequest apply(RequestBuilderAndToken<ListNetworkFirewallPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkFirewallPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkFirewallPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkFirewallPoliciesRequest, ListNetworkFirewallPoliciesResponse>(){

            @Override
            public ListNetworkFirewallPoliciesResponse apply(ListNetworkFirewallPoliciesRequest request) {
                return NetworkFirewallPaginators.this.client.listNetworkFirewallPolicies(request);
            }
        }, (Function)new Function<ListNetworkFirewallPoliciesResponse, List<NetworkFirewallPolicySummary>>(){

            @Override
            public List<NetworkFirewallPolicySummary> apply(ListNetworkFirewallPoliciesResponse response) {
                return response.getNetworkFirewallPolicySummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListNetworkFirewallsResponse> listNetworkFirewallsResponseIterator(final ListNetworkFirewallsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkFirewallsRequest.Builder>(){

            @Override
            public ListNetworkFirewallsRequest.Builder get() {
                return ListNetworkFirewallsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkFirewallsResponse, String>(){

            @Override
            public String apply(ListNetworkFirewallsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkFirewallsRequest.Builder>, ListNetworkFirewallsRequest>(){

            @Override
            public ListNetworkFirewallsRequest apply(RequestBuilderAndToken<ListNetworkFirewallsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkFirewallsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkFirewallsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkFirewallsRequest, ListNetworkFirewallsResponse>(){

            @Override
            public ListNetworkFirewallsResponse apply(ListNetworkFirewallsRequest request) {
                return NetworkFirewallPaginators.this.client.listNetworkFirewalls(request);
            }
        });
    }

    public Iterable<NetworkFirewallSummary> listNetworkFirewallsRecordIterator(final ListNetworkFirewallsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkFirewallsRequest.Builder>(){

            @Override
            public ListNetworkFirewallsRequest.Builder get() {
                return ListNetworkFirewallsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkFirewallsResponse, String>(){

            @Override
            public String apply(ListNetworkFirewallsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkFirewallsRequest.Builder>, ListNetworkFirewallsRequest>(){

            @Override
            public ListNetworkFirewallsRequest apply(RequestBuilderAndToken<ListNetworkFirewallsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkFirewallsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkFirewallsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkFirewallsRequest, ListNetworkFirewallsResponse>(){

            @Override
            public ListNetworkFirewallsResponse apply(ListNetworkFirewallsRequest request) {
                return NetworkFirewallPaginators.this.client.listNetworkFirewalls(request);
            }
        }, (Function)new Function<ListNetworkFirewallsResponse, List<NetworkFirewallSummary>>(){

            @Override
            public List<NetworkFirewallSummary> apply(ListNetworkFirewallsResponse response) {
                return response.getNetworkFirewallCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NetworkFirewallPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NetworkFirewallPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NetworkFirewallPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NetworkFirewallPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NetworkFirewallPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NetworkFirewallPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

