/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkfirewall;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.networkfirewall.NetworkFirewallAsync;
import com.oracle.bmc.networkfirewall.model.NetworkFirewall;
import com.oracle.bmc.networkfirewall.model.NetworkFirewallCollection;
import com.oracle.bmc.networkfirewall.model.NetworkFirewallPolicy;
import com.oracle.bmc.networkfirewall.model.NetworkFirewallPolicySummaryCollection;
import com.oracle.bmc.networkfirewall.model.WorkRequest;
import com.oracle.bmc.networkfirewall.model.WorkRequestErrorCollection;
import com.oracle.bmc.networkfirewall.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.networkfirewall.model.WorkRequestSummaryCollection;
import com.oracle.bmc.networkfirewall.requests.CancelWorkRequestRequest;
import com.oracle.bmc.networkfirewall.requests.ChangeNetworkFirewallCompartmentRequest;
import com.oracle.bmc.networkfirewall.requests.ChangeNetworkFirewallPolicyCompartmentRequest;
import com.oracle.bmc.networkfirewall.requests.CreateNetworkFirewallPolicyRequest;
import com.oracle.bmc.networkfirewall.requests.CreateNetworkFirewallRequest;
import com.oracle.bmc.networkfirewall.requests.DeleteNetworkFirewallPolicyRequest;
import com.oracle.bmc.networkfirewall.requests.DeleteNetworkFirewallRequest;
import com.oracle.bmc.networkfirewall.requests.GetNetworkFirewallPolicyRequest;
import com.oracle.bmc.networkfirewall.requests.GetNetworkFirewallRequest;
import com.oracle.bmc.networkfirewall.requests.GetWorkRequestRequest;
import com.oracle.bmc.networkfirewall.requests.ListNetworkFirewallPoliciesRequest;
import com.oracle.bmc.networkfirewall.requests.ListNetworkFirewallsRequest;
import com.oracle.bmc.networkfirewall.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.networkfirewall.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.networkfirewall.requests.ListWorkRequestsRequest;
import com.oracle.bmc.networkfirewall.requests.UpdateNetworkFirewallPolicyRequest;
import com.oracle.bmc.networkfirewall.requests.UpdateNetworkFirewallRequest;
import com.oracle.bmc.networkfirewall.responses.CancelWorkRequestResponse;
import com.oracle.bmc.networkfirewall.responses.ChangeNetworkFirewallCompartmentResponse;
import com.oracle.bmc.networkfirewall.responses.ChangeNetworkFirewallPolicyCompartmentResponse;
import com.oracle.bmc.networkfirewall.responses.CreateNetworkFirewallPolicyResponse;
import com.oracle.bmc.networkfirewall.responses.CreateNetworkFirewallResponse;
import com.oracle.bmc.networkfirewall.responses.DeleteNetworkFirewallPolicyResponse;
import com.oracle.bmc.networkfirewall.responses.DeleteNetworkFirewallResponse;
import com.oracle.bmc.networkfirewall.responses.GetNetworkFirewallPolicyResponse;
import com.oracle.bmc.networkfirewall.responses.GetNetworkFirewallResponse;
import com.oracle.bmc.networkfirewall.responses.GetWorkRequestResponse;
import com.oracle.bmc.networkfirewall.responses.ListNetworkFirewallPoliciesResponse;
import com.oracle.bmc.networkfirewall.responses.ListNetworkFirewallsResponse;
import com.oracle.bmc.networkfirewall.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.networkfirewall.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.networkfirewall.responses.ListWorkRequestsResponse;
import com.oracle.bmc.networkfirewall.responses.UpdateNetworkFirewallPolicyResponse;
import com.oracle.bmc.networkfirewall.responses.UpdateNetworkFirewallResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkFirewallAsyncClient
extends BaseAsyncClient
implements NetworkFirewallAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NETWORKFIREWALL").serviceEndpointPrefix("").serviceEndpointTemplate("https://network-firewall.{region}.ocs.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(NetworkFirewallAsyncClient.class);

    private NetworkFirewallAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("NetworkFirewall", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeNetworkFirewallCompartmentResponse> changeNetworkFirewallCompartment(ChangeNetworkFirewallCompartmentRequest request, AsyncHandler<ChangeNetworkFirewallCompartmentRequest, ChangeNetworkFirewallCompartmentResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallId(), (String)"networkFirewallId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNetworkFirewallCompartmentDetails(), "changeNetworkFirewallCompartmentDetails is required");
        return this.clientCall(request, ChangeNetworkFirewallCompartmentResponse::builder).logger(LOG, "changeNetworkFirewallCompartment").serviceDetails("NetworkFirewall", "ChangeNetworkFirewallCompartment", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewall/ChangeNetworkFirewallCompartment").method(Method.POST).requestBuilder(ChangeNetworkFirewallCompartmentRequest::builder).basePath("/20211001").appendPathParam("networkFirewalls").appendPathParam(request.getNetworkFirewallId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeNetworkFirewallCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeNetworkFirewallCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeNetworkFirewallPolicyCompartmentResponse> changeNetworkFirewallPolicyCompartment(ChangeNetworkFirewallPolicyCompartmentRequest request, AsyncHandler<ChangeNetworkFirewallPolicyCompartmentRequest, ChangeNetworkFirewallPolicyCompartmentResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallPolicyId(), (String)"networkFirewallPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNetworkFirewallPolicyCompartmentDetails(), "changeNetworkFirewallPolicyCompartmentDetails is required");
        return this.clientCall(request, ChangeNetworkFirewallPolicyCompartmentResponse::builder).logger(LOG, "changeNetworkFirewallPolicyCompartment").serviceDetails("NetworkFirewall", "ChangeNetworkFirewallPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewallPolicy/ChangeNetworkFirewallPolicyCompartment").method(Method.POST).requestBuilder(ChangeNetworkFirewallPolicyCompartmentRequest::builder).basePath("/20211001").appendPathParam("networkFirewallPolicies").appendPathParam(request.getNetworkFirewallPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeNetworkFirewallPolicyCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateNetworkFirewallResponse> createNetworkFirewall(CreateNetworkFirewallRequest request, AsyncHandler<CreateNetworkFirewallRequest, CreateNetworkFirewallResponse> handler) {
        Objects.requireNonNull(request.getCreateNetworkFirewallDetails(), "createNetworkFirewallDetails is required");
        return this.clientCall(request, CreateNetworkFirewallResponse::builder).logger(LOG, "createNetworkFirewall").serviceDetails("NetworkFirewall", "CreateNetworkFirewall", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewall/CreateNetworkFirewall").method(Method.POST).requestBuilder(CreateNetworkFirewallRequest::builder).basePath("/20211001").appendPathParam("networkFirewalls").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NetworkFirewall.class, CreateNetworkFirewallResponse.Builder::networkFirewall).handleResponseHeaderString("etag", CreateNetworkFirewallResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateNetworkFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNetworkFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateNetworkFirewallPolicyResponse> createNetworkFirewallPolicy(CreateNetworkFirewallPolicyRequest request, AsyncHandler<CreateNetworkFirewallPolicyRequest, CreateNetworkFirewallPolicyResponse> handler) {
        Objects.requireNonNull(request.getCreateNetworkFirewallPolicyDetails(), "createNetworkFirewallPolicyDetails is required");
        return this.clientCall(request, CreateNetworkFirewallPolicyResponse::builder).logger(LOG, "createNetworkFirewallPolicy").serviceDetails("NetworkFirewall", "CreateNetworkFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewallPolicy/CreateNetworkFirewallPolicy").method(Method.POST).requestBuilder(CreateNetworkFirewallPolicyRequest::builder).basePath("/20211001").appendPathParam("networkFirewallPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NetworkFirewallPolicy.class, CreateNetworkFirewallPolicyResponse.Builder::networkFirewallPolicy).handleResponseHeaderString("etag", CreateNetworkFirewallPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateNetworkFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNetworkFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNetworkFirewallResponse> deleteNetworkFirewall(DeleteNetworkFirewallRequest request, AsyncHandler<DeleteNetworkFirewallRequest, DeleteNetworkFirewallResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallId(), (String)"networkFirewallId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNetworkFirewallResponse::builder).logger(LOG, "deleteNetworkFirewall").serviceDetails("NetworkFirewall", "DeleteNetworkFirewall", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewall/DeleteNetworkFirewall").method(Method.DELETE).requestBuilder(DeleteNetworkFirewallRequest::builder).basePath("/20211001").appendPathParam("networkFirewalls").appendPathParam(request.getNetworkFirewallId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNetworkFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNetworkFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNetworkFirewallPolicyResponse> deleteNetworkFirewallPolicy(DeleteNetworkFirewallPolicyRequest request, AsyncHandler<DeleteNetworkFirewallPolicyRequest, DeleteNetworkFirewallPolicyResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallPolicyId(), (String)"networkFirewallPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNetworkFirewallPolicyResponse::builder).logger(LOG, "deleteNetworkFirewallPolicy").serviceDetails("NetworkFirewall", "DeleteNetworkFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewallPolicy/DeleteNetworkFirewallPolicy").method(Method.DELETE).requestBuilder(DeleteNetworkFirewallPolicyRequest::builder).basePath("/20211001").appendPathParam("networkFirewallPolicies").appendPathParam(request.getNetworkFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNetworkFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNetworkFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNetworkFirewallResponse> getNetworkFirewall(GetNetworkFirewallRequest request, AsyncHandler<GetNetworkFirewallRequest, GetNetworkFirewallResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallId(), (String)"networkFirewallId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNetworkFirewallResponse::builder).logger(LOG, "getNetworkFirewall").serviceDetails("NetworkFirewall", "GetNetworkFirewall", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewall/GetNetworkFirewall").method(Method.GET).requestBuilder(GetNetworkFirewallRequest::builder).basePath("/20211001").appendPathParam("networkFirewalls").appendPathParam(request.getNetworkFirewallId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkFirewall.class, GetNetworkFirewallResponse.Builder::networkFirewall).handleResponseHeaderString("etag", GetNetworkFirewallResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNetworkFirewallPolicyResponse> getNetworkFirewallPolicy(GetNetworkFirewallPolicyRequest request, AsyncHandler<GetNetworkFirewallPolicyRequest, GetNetworkFirewallPolicyResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallPolicyId(), (String)"networkFirewallPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNetworkFirewallPolicyResponse::builder).logger(LOG, "getNetworkFirewallPolicy").serviceDetails("NetworkFirewall", "GetNetworkFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewallPolicy/GetNetworkFirewallPolicy").method(Method.GET).requestBuilder(GetNetworkFirewallPolicyRequest::builder).basePath("/20211001").appendPathParam("networkFirewallPolicies").appendPathParam(request.getNetworkFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkFirewallPolicy.class, GetNetworkFirewallPolicyResponse.Builder::networkFirewallPolicy).handleResponseHeaderString("etag", GetNetworkFirewallPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("NetworkFirewall", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListNetworkFirewallPoliciesResponse> listNetworkFirewallPolicies(ListNetworkFirewallPoliciesRequest request, AsyncHandler<ListNetworkFirewallPoliciesRequest, ListNetworkFirewallPoliciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNetworkFirewallPoliciesResponse::builder).logger(LOG, "listNetworkFirewallPolicies").serviceDetails("NetworkFirewall", "ListNetworkFirewallPolicies", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewallPolicy/ListNetworkFirewallPolicies").method(Method.GET).requestBuilder(ListNetworkFirewallPoliciesRequest::builder).basePath("/20211001").appendPathParam("networkFirewallPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkFirewallPolicySummaryCollection.class, ListNetworkFirewallPoliciesResponse.Builder::networkFirewallPolicySummaryCollection).handleResponseHeaderString("opc-request-id", ListNetworkFirewallPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNetworkFirewallPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListNetworkFirewallPoliciesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-page-count", ListNetworkFirewallPoliciesResponse.Builder::opcPageCount).handleResponseHeaderInteger("opc-total-items", ListNetworkFirewallPoliciesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListNetworkFirewallsResponse> listNetworkFirewalls(ListNetworkFirewallsRequest request, AsyncHandler<ListNetworkFirewallsRequest, ListNetworkFirewallsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNetworkFirewallsResponse::builder).logger(LOG, "listNetworkFirewalls").serviceDetails("NetworkFirewall", "ListNetworkFirewalls", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewall/ListNetworkFirewalls").method(Method.GET).requestBuilder(ListNetworkFirewallsRequest::builder).basePath("/20211001").appendPathParam("networkFirewalls").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("networkFirewallPolicyId", (Object)request.getNetworkFirewallPolicyId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkFirewallCollection.class, ListNetworkFirewallsResponse.Builder::networkFirewallCollection).handleResponseHeaderString("opc-request-id", ListNetworkFirewallsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNetworkFirewallsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListNetworkFirewallsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-page-count", ListNetworkFirewallsResponse.Builder::opcPageCount).handleResponseHeaderInteger("opc-total-items", ListNetworkFirewallsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("NetworkFirewall", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListWorkRequestErrorsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("NetworkFirewall", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListWorkRequestLogsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("NetworkFirewall", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListWorkRequestsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateNetworkFirewallResponse> updateNetworkFirewall(UpdateNetworkFirewallRequest request, AsyncHandler<UpdateNetworkFirewallRequest, UpdateNetworkFirewallResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallId(), (String)"networkFirewallId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkFirewallDetails(), "updateNetworkFirewallDetails is required");
        return this.clientCall(request, UpdateNetworkFirewallResponse::builder).logger(LOG, "updateNetworkFirewall").serviceDetails("NetworkFirewall", "UpdateNetworkFirewall", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewall/UpdateNetworkFirewall").method(Method.PUT).requestBuilder(UpdateNetworkFirewallRequest::builder).basePath("/20211001").appendPathParam("networkFirewalls").appendPathParam(request.getNetworkFirewallId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateNetworkFirewallPolicyResponse> updateNetworkFirewallPolicy(UpdateNetworkFirewallPolicyRequest request, AsyncHandler<UpdateNetworkFirewallPolicyRequest, UpdateNetworkFirewallPolicyResponse> handler) {
        Validate.notBlank((String)request.getNetworkFirewallPolicyId(), (String)"networkFirewallPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkFirewallPolicyDetails(), "updateNetworkFirewallPolicyDetails is required");
        return this.clientCall(request, UpdateNetworkFirewallPolicyResponse::builder).logger(LOG, "updateNetworkFirewallPolicy").serviceDetails("NetworkFirewall", "UpdateNetworkFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/network-firewall/20211001/NetworkFirewallPolicy/UpdateNetworkFirewallPolicy").method(Method.PUT).requestBuilder(UpdateNetworkFirewallPolicyRequest::builder).basePath("/20211001").appendPathParam("networkFirewallPolicies").appendPathParam(request.getNetworkFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)NetworkFirewallAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(NetworkFirewallAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)NetworkFirewallAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)NetworkFirewallAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)NetworkFirewallAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)NetworkFirewallAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkFirewallAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NetworkFirewallAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NetworkFirewallAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public NetworkFirewallAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new NetworkFirewallAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

