/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.UpdateMediaAssetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateMediaAssetRequest
extends BmcRequest<UpdateMediaAssetDetails> {
    private String mediaAssetId;
    private UpdateMediaAssetDetails updateMediaAssetDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public UpdateMediaAssetDetails getUpdateMediaAssetDetails() {
        return this.updateMediaAssetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateMediaAssetDetails getBody$() {
        return this.updateMediaAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().mediaAssetId(this.mediaAssetId).updateMediaAssetDetails(this.updateMediaAssetDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(",updateMediaAssetDetails=").append(String.valueOf((Object)this.updateMediaAssetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMediaAssetRequest)) {
            return false;
        }
        UpdateMediaAssetRequest other = (UpdateMediaAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals((Object)this.updateMediaAssetDetails, (Object)other.updateMediaAssetDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.updateMediaAssetDetails == null ? 43 : this.updateMediaAssetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMediaAssetRequest, UpdateMediaAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaAssetId = null;
        private UpdateMediaAssetDetails updateMediaAssetDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            return this;
        }

        public Builder updateMediaAssetDetails(UpdateMediaAssetDetails updateMediaAssetDetails) {
            this.updateMediaAssetDetails = updateMediaAssetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMediaAssetRequest o) {
            this.mediaAssetId(o.getMediaAssetId());
            this.updateMediaAssetDetails(o.getUpdateMediaAssetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMediaAssetRequest build() {
            UpdateMediaAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMediaAssetDetails body) {
            this.updateMediaAssetDetails(body);
            return this;
        }

        public UpdateMediaAssetRequest buildWithoutInvocationCallback() {
            UpdateMediaAssetRequest request = new UpdateMediaAssetRequest();
            request.mediaAssetId = this.mediaAssetId;
            request.updateMediaAssetDetails = this.updateMediaAssetDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

