/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.SortBy;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.mediaservices.model.StreamPackagingConfig;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListStreamPackagingConfigsRequest
extends BmcRequest<Void> {
    private String distributionChannelId;
    private String streamPackagingConfigId;
    private StreamPackagingConfig.LifecycleState lifecycleState;
    private String displayName;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String page;
    private Integer limit;
    private String opcRequestId;

    public String getDistributionChannelId() {
        return this.distributionChannelId;
    }

    public String getStreamPackagingConfigId() {
        return this.streamPackagingConfigId;
    }

    public StreamPackagingConfig.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().distributionChannelId(this.distributionChannelId).streamPackagingConfigId(this.streamPackagingConfigId).lifecycleState(this.lifecycleState).displayName(this.displayName).sortOrder(this.sortOrder).sortBy(this.sortBy).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",distributionChannelId=").append(String.valueOf(this.distributionChannelId));
        sb.append(",streamPackagingConfigId=").append(String.valueOf(this.streamPackagingConfigId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListStreamPackagingConfigsRequest)) {
            return false;
        }
        ListStreamPackagingConfigsRequest other = (ListStreamPackagingConfigsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.distributionChannelId, other.distributionChannelId) && Objects.equals(this.streamPackagingConfigId, other.streamPackagingConfigId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.distributionChannelId == null ? 43 : this.distributionChannelId.hashCode());
        result = result * 59 + (this.streamPackagingConfigId == null ? 43 : this.streamPackagingConfigId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListStreamPackagingConfigsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String distributionChannelId = null;
        private String streamPackagingConfigId = null;
        private StreamPackagingConfig.LifecycleState lifecycleState = null;
        private String displayName = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder distributionChannelId(String distributionChannelId) {
            this.distributionChannelId = distributionChannelId;
            return this;
        }

        public Builder streamPackagingConfigId(String streamPackagingConfigId) {
            this.streamPackagingConfigId = streamPackagingConfigId;
            return this;
        }

        public Builder lifecycleState(StreamPackagingConfig.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListStreamPackagingConfigsRequest o) {
            this.distributionChannelId(o.getDistributionChannelId());
            this.streamPackagingConfigId(o.getStreamPackagingConfigId());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListStreamPackagingConfigsRequest build() {
            ListStreamPackagingConfigsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListStreamPackagingConfigsRequest buildWithoutInvocationCallback() {
            ListStreamPackagingConfigsRequest request = new ListStreamPackagingConfigsRequest();
            request.distributionChannelId = this.distributionChannelId;
            request.streamPackagingConfigId = this.streamPackagingConfigId;
            request.lifecycleState = this.lifecycleState;
            request.displayName = this.displayName;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

