/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.mediaservices.model.MediaWorkflowJobFactSortBy;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListMediaWorkflowJobFactsRequest
extends BmcRequest<Void> {
    private String mediaWorkflowJobId;
    private Integer key;
    private Type type;
    private MediaWorkflowJobFactSortBy sortBy;
    private SortOrder sortOrder;
    private String page;
    private Integer limit;
    private String opcRequestId;

    public String getMediaWorkflowJobId() {
        return this.mediaWorkflowJobId;
    }

    public Integer getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public MediaWorkflowJobFactSortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().mediaWorkflowJobId(this.mediaWorkflowJobId).key(this.key).type(this.type).sortBy(this.sortBy).sortOrder(this.sortOrder).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaWorkflowJobId=").append(String.valueOf(this.mediaWorkflowJobId));
        sb.append(",key=").append(String.valueOf(this.key));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMediaWorkflowJobFactsRequest)) {
            return false;
        }
        ListMediaWorkflowJobFactsRequest other = (ListMediaWorkflowJobFactsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaWorkflowJobId, other.mediaWorkflowJobId) && Objects.equals(this.key, other.key) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaWorkflowJobId == null ? 43 : this.mediaWorkflowJobId.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMediaWorkflowJobFactsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaWorkflowJobId = null;
        private Integer key = null;
        private Type type = null;
        private MediaWorkflowJobFactSortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder mediaWorkflowJobId(String mediaWorkflowJobId) {
            this.mediaWorkflowJobId = mediaWorkflowJobId;
            return this;
        }

        public Builder key(Integer key) {
            this.key = key;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder sortBy(MediaWorkflowJobFactSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMediaWorkflowJobFactsRequest o) {
            this.mediaWorkflowJobId(o.getMediaWorkflowJobId());
            this.key(o.getKey());
            this.type(o.getType());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMediaWorkflowJobFactsRequest build() {
            ListMediaWorkflowJobFactsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMediaWorkflowJobFactsRequest buildWithoutInvocationCallback() {
            ListMediaWorkflowJobFactsRequest request = new ListMediaWorkflowJobFactsRequest();
            request.mediaWorkflowJobId = this.mediaWorkflowJobId;
            request.key = this.key;
            request.type = this.type;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum Type implements BmcEnum
    {
        RunnableJob("runnableJob"),
        TaskDeclaration("taskDeclaration"),
        Workflow("workflow"),
        Configuration("configuration"),
        ParameterResolutionEvent("parameterResolutionEvent");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

