/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.MediaAssetDistributionChannelAttachmentSortBy;
import com.oracle.bmc.mediaservices.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListMediaAssetDistributionChannelAttachmentsRequest
extends BmcRequest<Void> {
    private String mediaAssetId;
    private String displayName;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortOrder sortOrder;
    private MediaAssetDistributionChannelAttachmentSortBy sortBy;
    private String distributionChannelId;

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public MediaAssetDistributionChannelAttachmentSortBy getSortBy() {
        return this.sortBy;
    }

    public String getDistributionChannelId() {
        return this.distributionChannelId;
    }

    public Builder toBuilder() {
        return new Builder().mediaAssetId(this.mediaAssetId).displayName(this.displayName).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortOrder(this.sortOrder).sortBy(this.sortBy).distributionChannelId(this.distributionChannelId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",distributionChannelId=").append(String.valueOf(this.distributionChannelId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMediaAssetDistributionChannelAttachmentsRequest)) {
            return false;
        }
        ListMediaAssetDistributionChannelAttachmentsRequest other = (ListMediaAssetDistributionChannelAttachmentsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.distributionChannelId, other.distributionChannelId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.distributionChannelId == null ? 43 : this.distributionChannelId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMediaAssetDistributionChannelAttachmentsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaAssetId = null;
        private String displayName = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortOrder sortOrder = null;
        private MediaAssetDistributionChannelAttachmentSortBy sortBy = null;
        private String distributionChannelId = null;

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(MediaAssetDistributionChannelAttachmentSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder distributionChannelId(String distributionChannelId) {
            this.distributionChannelId = distributionChannelId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMediaAssetDistributionChannelAttachmentsRequest o) {
            this.mediaAssetId(o.getMediaAssetId());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.distributionChannelId(o.getDistributionChannelId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMediaAssetDistributionChannelAttachmentsRequest build() {
            ListMediaAssetDistributionChannelAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMediaAssetDistributionChannelAttachmentsRequest buildWithoutInvocationCallback() {
            ListMediaAssetDistributionChannelAttachmentsRequest request = new ListMediaAssetDistributionChannelAttachmentsRequest();
            request.mediaAssetId = this.mediaAssetId;
            request.displayName = this.displayName;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.distributionChannelId = this.distributionChannelId;
            return request;
        }
    }
}

