/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStreamPackagingConfigRequest
extends BmcRequest<Void> {
    private String streamPackagingConfigId;
    private String opcRequestId;

    public String getStreamPackagingConfigId() {
        return this.streamPackagingConfigId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().streamPackagingConfigId(this.streamPackagingConfigId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamPackagingConfigId=").append(String.valueOf(this.streamPackagingConfigId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStreamPackagingConfigRequest)) {
            return false;
        }
        GetStreamPackagingConfigRequest other = (GetStreamPackagingConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamPackagingConfigId, other.streamPackagingConfigId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamPackagingConfigId == null ? 43 : this.streamPackagingConfigId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStreamPackagingConfigRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamPackagingConfigId = null;
        private String opcRequestId = null;

        public Builder streamPackagingConfigId(String streamPackagingConfigId) {
            this.streamPackagingConfigId = streamPackagingConfigId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStreamPackagingConfigRequest o) {
            this.streamPackagingConfigId(o.getStreamPackagingConfigId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStreamPackagingConfigRequest build() {
            GetStreamPackagingConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStreamPackagingConfigRequest buildWithoutInvocationCallback() {
            GetStreamPackagingConfigRequest request = new GetStreamPackagingConfigRequest();
            request.streamPackagingConfigId = this.streamPackagingConfigId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

