/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStreamDistributionChannelRequest
extends BmcRequest<Void> {
    private String streamDistributionChannelId;
    private String opcRequestId;

    public String getStreamDistributionChannelId() {
        return this.streamDistributionChannelId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().streamDistributionChannelId(this.streamDistributionChannelId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamDistributionChannelId=").append(String.valueOf(this.streamDistributionChannelId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStreamDistributionChannelRequest)) {
            return false;
        }
        GetStreamDistributionChannelRequest other = (GetStreamDistributionChannelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamDistributionChannelId, other.streamDistributionChannelId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamDistributionChannelId == null ? 43 : this.streamDistributionChannelId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStreamDistributionChannelRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamDistributionChannelId = null;
        private String opcRequestId = null;

        public Builder streamDistributionChannelId(String streamDistributionChannelId) {
            this.streamDistributionChannelId = streamDistributionChannelId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStreamDistributionChannelRequest o) {
            this.streamDistributionChannelId(o.getStreamDistributionChannelId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStreamDistributionChannelRequest build() {
            GetStreamDistributionChannelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStreamDistributionChannelRequest buildWithoutInvocationCallback() {
            GetStreamDistributionChannelRequest request = new GetStreamDistributionChannelRequest();
            request.streamDistributionChannelId = this.streamDistributionChannelId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

