/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStreamCdnConfigRequest
extends BmcRequest<Void> {
    private String streamCdnConfigId;
    private String opcRequestId;

    public String getStreamCdnConfigId() {
        return this.streamCdnConfigId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().streamCdnConfigId(this.streamCdnConfigId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamCdnConfigId=").append(String.valueOf(this.streamCdnConfigId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStreamCdnConfigRequest)) {
            return false;
        }
        GetStreamCdnConfigRequest other = (GetStreamCdnConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamCdnConfigId, other.streamCdnConfigId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamCdnConfigId == null ? 43 : this.streamCdnConfigId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStreamCdnConfigRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamCdnConfigId = null;
        private String opcRequestId = null;

        public Builder streamCdnConfigId(String streamCdnConfigId) {
            this.streamCdnConfigId = streamCdnConfigId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStreamCdnConfigRequest o) {
            this.streamCdnConfigId(o.getStreamCdnConfigId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStreamCdnConfigRequest build() {
            GetStreamCdnConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStreamCdnConfigRequest buildWithoutInvocationCallback() {
            GetStreamCdnConfigRequest request = new GetStreamCdnConfigRequest();
            request.streamCdnConfigId = this.streamCdnConfigId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

