/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMediaWorkflowJobFactRequest
extends BmcRequest<Void> {
    private String mediaWorkflowJobId;
    private Integer key;
    private String opcRequestId;

    public String getMediaWorkflowJobId() {
        return this.mediaWorkflowJobId;
    }

    public Integer getKey() {
        return this.key;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().mediaWorkflowJobId(this.mediaWorkflowJobId).key(this.key).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaWorkflowJobId=").append(String.valueOf(this.mediaWorkflowJobId));
        sb.append(",key=").append(String.valueOf(this.key));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMediaWorkflowJobFactRequest)) {
            return false;
        }
        GetMediaWorkflowJobFactRequest other = (GetMediaWorkflowJobFactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaWorkflowJobId, other.mediaWorkflowJobId) && Objects.equals(this.key, other.key) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaWorkflowJobId == null ? 43 : this.mediaWorkflowJobId.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMediaWorkflowJobFactRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaWorkflowJobId = null;
        private Integer key = null;
        private String opcRequestId = null;

        public Builder mediaWorkflowJobId(String mediaWorkflowJobId) {
            this.mediaWorkflowJobId = mediaWorkflowJobId;
            return this;
        }

        public Builder key(Integer key) {
            this.key = key;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMediaWorkflowJobFactRequest o) {
            this.mediaWorkflowJobId(o.getMediaWorkflowJobId());
            this.key(o.getKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMediaWorkflowJobFactRequest build() {
            GetMediaWorkflowJobFactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMediaWorkflowJobFactRequest buildWithoutInvocationCallback() {
            GetMediaWorkflowJobFactRequest request = new GetMediaWorkflowJobFactRequest();
            request.mediaWorkflowJobId = this.mediaWorkflowJobId;
            request.key = this.key;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

