/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMediaAssetDistributionChannelAttachmentRequest
extends BmcRequest<Void> {
    private String mediaAssetId;
    private String distributionChannelId;
    private String opcRequestId;
    private Long version;

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public String getDistributionChannelId() {
        return this.distributionChannelId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getVersion() {
        return this.version;
    }

    public Builder toBuilder() {
        return new Builder().mediaAssetId(this.mediaAssetId).distributionChannelId(this.distributionChannelId).opcRequestId(this.opcRequestId).version(this.version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(",distributionChannelId=").append(String.valueOf(this.distributionChannelId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",version=").append(String.valueOf(this.version));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMediaAssetDistributionChannelAttachmentRequest)) {
            return false;
        }
        GetMediaAssetDistributionChannelAttachmentRequest other = (GetMediaAssetDistributionChannelAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals(this.distributionChannelId, other.distributionChannelId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.distributionChannelId == null ? 43 : this.distributionChannelId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMediaAssetDistributionChannelAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String mediaAssetId = null;
        private String distributionChannelId = null;
        private String opcRequestId = null;
        private Long version = null;

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            return this;
        }

        public Builder distributionChannelId(String distributionChannelId) {
            this.distributionChannelId = distributionChannelId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMediaAssetDistributionChannelAttachmentRequest o) {
            this.mediaAssetId(o.getMediaAssetId());
            this.distributionChannelId(o.getDistributionChannelId());
            this.opcRequestId(o.getOpcRequestId());
            this.version(o.getVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMediaAssetDistributionChannelAttachmentRequest build() {
            GetMediaAssetDistributionChannelAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMediaAssetDistributionChannelAttachmentRequest buildWithoutInvocationCallback() {
            GetMediaAssetDistributionChannelAttachmentRequest request = new GetMediaAssetDistributionChannelAttachmentRequest();
            request.mediaAssetId = this.mediaAssetId;
            request.distributionChannelId = this.distributionChannelId;
            request.opcRequestId = this.opcRequestId;
            request.version = this.version;
            return request;
        }
    }
}

