/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GeneratePlaylistRequest
extends BmcRequest<Void> {
    private String streamPackagingConfigId;
    private String mediaAssetId;
    private String opcRequestId;
    private String token;

    public String getStreamPackagingConfigId() {
        return this.streamPackagingConfigId;
    }

    public String getMediaAssetId() {
        return this.mediaAssetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getToken() {
        return this.token;
    }

    public Builder toBuilder() {
        return new Builder().streamPackagingConfigId(this.streamPackagingConfigId).mediaAssetId(this.mediaAssetId).opcRequestId(this.opcRequestId).token(this.token);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamPackagingConfigId=").append(String.valueOf(this.streamPackagingConfigId));
        sb.append(",mediaAssetId=").append(String.valueOf(this.mediaAssetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",token=").append(String.valueOf(this.token));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneratePlaylistRequest)) {
            return false;
        }
        GeneratePlaylistRequest other = (GeneratePlaylistRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamPackagingConfigId, other.streamPackagingConfigId) && Objects.equals(this.mediaAssetId, other.mediaAssetId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.token, other.token);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamPackagingConfigId == null ? 43 : this.streamPackagingConfigId.hashCode());
        result = result * 59 + (this.mediaAssetId == null ? 43 : this.mediaAssetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.token == null ? 43 : this.token.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GeneratePlaylistRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamPackagingConfigId = null;
        private String mediaAssetId = null;
        private String opcRequestId = null;
        private String token = null;

        public Builder streamPackagingConfigId(String streamPackagingConfigId) {
            this.streamPackagingConfigId = streamPackagingConfigId;
            return this;
        }

        public Builder mediaAssetId(String mediaAssetId) {
            this.mediaAssetId = mediaAssetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GeneratePlaylistRequest o) {
            this.streamPackagingConfigId(o.getStreamPackagingConfigId());
            this.mediaAssetId(o.getMediaAssetId());
            this.opcRequestId(o.getOpcRequestId());
            this.token(o.getToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GeneratePlaylistRequest build() {
            GeneratePlaylistRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GeneratePlaylistRequest buildWithoutInvocationCallback() {
            GeneratePlaylistRequest request = new GeneratePlaylistRequest();
            request.streamPackagingConfigId = this.streamPackagingConfigId;
            request.mediaAssetId = this.mediaAssetId;
            request.opcRequestId = this.opcRequestId;
            request.token = this.token;
            return request;
        }
    }
}

