/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.mediaservices.model.CreateMediaWorkflowDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateMediaWorkflowRequest
extends BmcRequest<CreateMediaWorkflowDetails> {
    private CreateMediaWorkflowDetails createMediaWorkflowDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateMediaWorkflowDetails getCreateMediaWorkflowDetails() {
        return this.createMediaWorkflowDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateMediaWorkflowDetails getBody$() {
        return this.createMediaWorkflowDetails;
    }

    public Builder toBuilder() {
        return new Builder().createMediaWorkflowDetails(this.createMediaWorkflowDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createMediaWorkflowDetails=").append(String.valueOf((Object)this.createMediaWorkflowDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMediaWorkflowRequest)) {
            return false;
        }
        CreateMediaWorkflowRequest other = (CreateMediaWorkflowRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createMediaWorkflowDetails, (Object)other.createMediaWorkflowDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createMediaWorkflowDetails == null ? 43 : this.createMediaWorkflowDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateMediaWorkflowRequest, CreateMediaWorkflowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateMediaWorkflowDetails createMediaWorkflowDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createMediaWorkflowDetails(CreateMediaWorkflowDetails createMediaWorkflowDetails) {
            this.createMediaWorkflowDetails = createMediaWorkflowDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateMediaWorkflowRequest o) {
            this.createMediaWorkflowDetails(o.getCreateMediaWorkflowDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateMediaWorkflowRequest build() {
            CreateMediaWorkflowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateMediaWorkflowDetails body) {
            this.createMediaWorkflowDetails(body);
            return this;
        }

        public CreateMediaWorkflowRequest buildWithoutInvocationCallback() {
            CreateMediaWorkflowRequest request = new CreateMediaWorkflowRequest();
            request.createMediaWorkflowDetails = this.createMediaWorkflowDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

