/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MediaWorkflowTask
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="version")
    private final Long version;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="prerequisites")
    private final List<String> prerequisites;
    @JsonProperty(value="enableParameterReference")
    private final String enableParameterReference;
    @JsonProperty(value="enableWhenReferencedParameterEquals")
    private final Map<String, Object> enableWhenReferencedParameterEquals;
    @JsonProperty(value="parameters")
    private final Map<String, Object> parameters;

    @Deprecated
    @ConstructorProperties(value={"type", "version", "key", "prerequisites", "enableParameterReference", "enableWhenReferencedParameterEquals", "parameters"})
    public MediaWorkflowTask(String type, Long version, String key, List<String> prerequisites, String enableParameterReference, Map<String, Object> enableWhenReferencedParameterEquals, Map<String, Object> parameters) {
        this.type = type;
        this.version = version;
        this.key = key;
        this.prerequisites = prerequisites;
        this.enableParameterReference = enableParameterReference;
        this.enableWhenReferencedParameterEquals = enableWhenReferencedParameterEquals;
        this.parameters = parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getType() {
        return this.type;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public String getEnableParameterReference() {
        return this.enableParameterReference;
    }

    public Map<String, Object> getEnableWhenReferencedParameterEquals() {
        return this.enableWhenReferencedParameterEquals;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaWorkflowTask(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf(this.type));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", prerequisites=").append(String.valueOf(this.prerequisites));
        sb.append(", enableParameterReference=").append(String.valueOf(this.enableParameterReference));
        sb.append(", enableWhenReferencedParameterEquals=").append(String.valueOf(this.enableWhenReferencedParameterEquals));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaWorkflowTask)) {
            return false;
        }
        MediaWorkflowTask other = (MediaWorkflowTask)((Object)o);
        return Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals(this.key, other.key) && Objects.equals(this.prerequisites, other.prerequisites) && Objects.equals(this.enableParameterReference, other.enableParameterReference) && Objects.equals(this.enableWhenReferencedParameterEquals, other.enableWhenReferencedParameterEquals) && Objects.equals(this.parameters, other.parameters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.prerequisites == null ? 43 : this.prerequisites.hashCode());
        result = result * 59 + (this.enableParameterReference == null ? 43 : this.enableParameterReference.hashCode());
        result = result * 59 + (this.enableWhenReferencedParameterEquals == null ? 43 : this.enableWhenReferencedParameterEquals.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="version")
        private Long version;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="prerequisites")
        private List<String> prerequisites;
        @JsonProperty(value="enableParameterReference")
        private String enableParameterReference;
        @JsonProperty(value="enableWhenReferencedParameterEquals")
        private Map<String, Object> enableWhenReferencedParameterEquals;
        @JsonProperty(value="parameters")
        private Map<String, Object> parameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder prerequisites(List<String> prerequisites) {
            this.prerequisites = prerequisites;
            this.__explicitlySet__.add("prerequisites");
            return this;
        }

        public Builder enableParameterReference(String enableParameterReference) {
            this.enableParameterReference = enableParameterReference;
            this.__explicitlySet__.add("enableParameterReference");
            return this;
        }

        public Builder enableWhenReferencedParameterEquals(Map<String, Object> enableWhenReferencedParameterEquals) {
            this.enableWhenReferencedParameterEquals = enableWhenReferencedParameterEquals;
            this.__explicitlySet__.add("enableWhenReferencedParameterEquals");
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public MediaWorkflowTask build() {
            MediaWorkflowTask model = new MediaWorkflowTask(this.type, this.version, this.key, this.prerequisites, this.enableParameterReference, this.enableWhenReferencedParameterEquals, this.parameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MediaWorkflowTask model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("prerequisites")) {
                this.prerequisites(model.getPrerequisites());
            }
            if (model.wasPropertyExplicitlySet("enableParameterReference")) {
                this.enableParameterReference(model.getEnableParameterReference());
            }
            if (model.wasPropertyExplicitlySet("enableWhenReferencedParameterEquals")) {
                this.enableWhenReferencedParameterEquals(model.getEnableWhenReferencedParameterEquals());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            return this;
        }
    }
}

