/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.mediaservices.model.AssetType;
import com.oracle.bmc.mediaservices.model.LifecycleState;
import com.oracle.bmc.mediaservices.model.MediaAssetTag;
import com.oracle.bmc.mediaservices.model.Metadata;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MediaAsset
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="sourceMediaWorkflowId")
    private final String sourceMediaWorkflowId;
    @JsonProperty(value="mediaWorkflowJobId")
    private final String mediaWorkflowJobId;
    @JsonProperty(value="sourceMediaWorkflowVersion")
    private final Long sourceMediaWorkflowVersion;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="type")
    private final AssetType type;
    @JsonProperty(value="parentMediaAssetId")
    private final String parentMediaAssetId;
    @JsonProperty(value="masterMediaAssetId")
    private final String masterMediaAssetId;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="namespaceName")
    private final String namespaceName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="objectEtag")
    private final String objectEtag;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="segmentRangeStartIndex")
    private final Long segmentRangeStartIndex;
    @JsonProperty(value="segmentRangeEndIndex")
    private final Long segmentRangeEndIndex;
    @JsonProperty(value="metadata")
    private final List<Metadata> metadata;
    @JsonProperty(value="mediaAssetTags")
    private final List<MediaAssetTag> mediaAssetTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "sourceMediaWorkflowId", "mediaWorkflowJobId", "sourceMediaWorkflowVersion", "displayName", "timeCreated", "lifecycleState", "type", "parentMediaAssetId", "masterMediaAssetId", "bucketName", "namespaceName", "objectName", "objectEtag", "timeUpdated", "segmentRangeStartIndex", "segmentRangeEndIndex", "metadata", "mediaAssetTags", "freeformTags", "definedTags", "systemTags"})
    public MediaAsset(String id, String compartmentId, String sourceMediaWorkflowId, String mediaWorkflowJobId, Long sourceMediaWorkflowVersion, String displayName, Date timeCreated, LifecycleState lifecycleState, AssetType type, String parentMediaAssetId, String masterMediaAssetId, String bucketName, String namespaceName, String objectName, String objectEtag, Date timeUpdated, Long segmentRangeStartIndex, Long segmentRangeEndIndex, List<Metadata> metadata, List<MediaAssetTag> mediaAssetTags, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.sourceMediaWorkflowId = sourceMediaWorkflowId;
        this.mediaWorkflowJobId = mediaWorkflowJobId;
        this.sourceMediaWorkflowVersion = sourceMediaWorkflowVersion;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.type = type;
        this.parentMediaAssetId = parentMediaAssetId;
        this.masterMediaAssetId = masterMediaAssetId;
        this.bucketName = bucketName;
        this.namespaceName = namespaceName;
        this.objectName = objectName;
        this.objectEtag = objectEtag;
        this.timeUpdated = timeUpdated;
        this.segmentRangeStartIndex = segmentRangeStartIndex;
        this.segmentRangeEndIndex = segmentRangeEndIndex;
        this.metadata = metadata;
        this.mediaAssetTags = mediaAssetTags;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSourceMediaWorkflowId() {
        return this.sourceMediaWorkflowId;
    }

    public String getMediaWorkflowJobId() {
        return this.mediaWorkflowJobId;
    }

    public Long getSourceMediaWorkflowVersion() {
        return this.sourceMediaWorkflowVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public AssetType getType() {
        return this.type;
    }

    public String getParentMediaAssetId() {
        return this.parentMediaAssetId;
    }

    public String getMasterMediaAssetId() {
        return this.masterMediaAssetId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectEtag() {
        return this.objectEtag;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Long getSegmentRangeStartIndex() {
        return this.segmentRangeStartIndex;
    }

    public Long getSegmentRangeEndIndex() {
        return this.segmentRangeEndIndex;
    }

    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public List<MediaAssetTag> getMediaAssetTags() {
        return this.mediaAssetTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaAsset(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", sourceMediaWorkflowId=").append(String.valueOf(this.sourceMediaWorkflowId));
        sb.append(", mediaWorkflowJobId=").append(String.valueOf(this.mediaWorkflowJobId));
        sb.append(", sourceMediaWorkflowVersion=").append(String.valueOf(this.sourceMediaWorkflowVersion));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", parentMediaAssetId=").append(String.valueOf(this.parentMediaAssetId));
        sb.append(", masterMediaAssetId=").append(String.valueOf(this.masterMediaAssetId));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", objectEtag=").append(String.valueOf(this.objectEtag));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", segmentRangeStartIndex=").append(String.valueOf(this.segmentRangeStartIndex));
        sb.append(", segmentRangeEndIndex=").append(String.valueOf(this.segmentRangeEndIndex));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", mediaAssetTags=").append(String.valueOf(this.mediaAssetTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaAsset)) {
            return false;
        }
        MediaAsset other = (MediaAsset)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.sourceMediaWorkflowId, other.sourceMediaWorkflowId) && Objects.equals(this.mediaWorkflowJobId, other.mediaWorkflowJobId) && Objects.equals(this.sourceMediaWorkflowVersion, other.sourceMediaWorkflowVersion) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.parentMediaAssetId, other.parentMediaAssetId) && Objects.equals(this.masterMediaAssetId, other.masterMediaAssetId) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.objectEtag, other.objectEtag) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.segmentRangeStartIndex, other.segmentRangeStartIndex) && Objects.equals(this.segmentRangeEndIndex, other.segmentRangeEndIndex) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.mediaAssetTags, other.mediaAssetTags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sourceMediaWorkflowId == null ? 43 : this.sourceMediaWorkflowId.hashCode());
        result = result * 59 + (this.mediaWorkflowJobId == null ? 43 : this.mediaWorkflowJobId.hashCode());
        result = result * 59 + (this.sourceMediaWorkflowVersion == null ? 43 : this.sourceMediaWorkflowVersion.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.parentMediaAssetId == null ? 43 : this.parentMediaAssetId.hashCode());
        result = result * 59 + (this.masterMediaAssetId == null ? 43 : this.masterMediaAssetId.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.objectEtag == null ? 43 : this.objectEtag.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.segmentRangeStartIndex == null ? 43 : this.segmentRangeStartIndex.hashCode());
        result = result * 59 + (this.segmentRangeEndIndex == null ? 43 : this.segmentRangeEndIndex.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.mediaAssetTags == null ? 43 : this.mediaAssetTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sourceMediaWorkflowId")
        private String sourceMediaWorkflowId;
        @JsonProperty(value="mediaWorkflowJobId")
        private String mediaWorkflowJobId;
        @JsonProperty(value="sourceMediaWorkflowVersion")
        private Long sourceMediaWorkflowVersion;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="type")
        private AssetType type;
        @JsonProperty(value="parentMediaAssetId")
        private String parentMediaAssetId;
        @JsonProperty(value="masterMediaAssetId")
        private String masterMediaAssetId;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="namespaceName")
        private String namespaceName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="objectEtag")
        private String objectEtag;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="segmentRangeStartIndex")
        private Long segmentRangeStartIndex;
        @JsonProperty(value="segmentRangeEndIndex")
        private Long segmentRangeEndIndex;
        @JsonProperty(value="metadata")
        private List<Metadata> metadata;
        @JsonProperty(value="mediaAssetTags")
        private List<MediaAssetTag> mediaAssetTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sourceMediaWorkflowId(String sourceMediaWorkflowId) {
            this.sourceMediaWorkflowId = sourceMediaWorkflowId;
            this.__explicitlySet__.add("sourceMediaWorkflowId");
            return this;
        }

        public Builder mediaWorkflowJobId(String mediaWorkflowJobId) {
            this.mediaWorkflowJobId = mediaWorkflowJobId;
            this.__explicitlySet__.add("mediaWorkflowJobId");
            return this;
        }

        public Builder sourceMediaWorkflowVersion(Long sourceMediaWorkflowVersion) {
            this.sourceMediaWorkflowVersion = sourceMediaWorkflowVersion;
            this.__explicitlySet__.add("sourceMediaWorkflowVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder type(AssetType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder parentMediaAssetId(String parentMediaAssetId) {
            this.parentMediaAssetId = parentMediaAssetId;
            this.__explicitlySet__.add("parentMediaAssetId");
            return this;
        }

        public Builder masterMediaAssetId(String masterMediaAssetId) {
            this.masterMediaAssetId = masterMediaAssetId;
            this.__explicitlySet__.add("masterMediaAssetId");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            this.__explicitlySet__.add("namespaceName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder objectEtag(String objectEtag) {
            this.objectEtag = objectEtag;
            this.__explicitlySet__.add("objectEtag");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder segmentRangeStartIndex(Long segmentRangeStartIndex) {
            this.segmentRangeStartIndex = segmentRangeStartIndex;
            this.__explicitlySet__.add("segmentRangeStartIndex");
            return this;
        }

        public Builder segmentRangeEndIndex(Long segmentRangeEndIndex) {
            this.segmentRangeEndIndex = segmentRangeEndIndex;
            this.__explicitlySet__.add("segmentRangeEndIndex");
            return this;
        }

        public Builder metadata(List<Metadata> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder mediaAssetTags(List<MediaAssetTag> mediaAssetTags) {
            this.mediaAssetTags = mediaAssetTags;
            this.__explicitlySet__.add("mediaAssetTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public MediaAsset build() {
            MediaAsset model = new MediaAsset(this.id, this.compartmentId, this.sourceMediaWorkflowId, this.mediaWorkflowJobId, this.sourceMediaWorkflowVersion, this.displayName, this.timeCreated, this.lifecycleState, this.type, this.parentMediaAssetId, this.masterMediaAssetId, this.bucketName, this.namespaceName, this.objectName, this.objectEtag, this.timeUpdated, this.segmentRangeStartIndex, this.segmentRangeEndIndex, this.metadata, this.mediaAssetTags, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MediaAsset model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sourceMediaWorkflowId")) {
                this.sourceMediaWorkflowId(model.getSourceMediaWorkflowId());
            }
            if (model.wasPropertyExplicitlySet("mediaWorkflowJobId")) {
                this.mediaWorkflowJobId(model.getMediaWorkflowJobId());
            }
            if (model.wasPropertyExplicitlySet("sourceMediaWorkflowVersion")) {
                this.sourceMediaWorkflowVersion(model.getSourceMediaWorkflowVersion());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("parentMediaAssetId")) {
                this.parentMediaAssetId(model.getParentMediaAssetId());
            }
            if (model.wasPropertyExplicitlySet("masterMediaAssetId")) {
                this.masterMediaAssetId(model.getMasterMediaAssetId());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("namespaceName")) {
                this.namespaceName(model.getNamespaceName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectEtag")) {
                this.objectEtag(model.getObjectEtag());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("segmentRangeStartIndex")) {
                this.segmentRangeStartIndex(model.getSegmentRangeStartIndex());
            }
            if (model.wasPropertyExplicitlySet("segmentRangeEndIndex")) {
                this.segmentRangeEndIndex(model.getSegmentRangeEndIndex());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("mediaAssetTags")) {
                this.mediaAssetTags(model.getMediaAssetTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

