/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mediaservices.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GenerateSessionTokenDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeExpires")
    private final Date timeExpires;
    @JsonProperty(value="scopes")
    private final List<Scopes> scopes;
    @JsonProperty(value="packagingConfigId")
    private final String packagingConfigId;
    @JsonProperty(value="assetIds")
    private final List<String> assetIds;

    @Deprecated
    @ConstructorProperties(value={"timeExpires", "scopes", "packagingConfigId", "assetIds"})
    public GenerateSessionTokenDetails(Date timeExpires, List<Scopes> scopes, String packagingConfigId, List<String> assetIds) {
        this.timeExpires = timeExpires;
        this.scopes = scopes;
        this.packagingConfigId = packagingConfigId;
        this.assetIds = assetIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeExpires() {
        return this.timeExpires;
    }

    public List<Scopes> getScopes() {
        return this.scopes;
    }

    public String getPackagingConfigId() {
        return this.packagingConfigId;
    }

    public List<String> getAssetIds() {
        return this.assetIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateSessionTokenDetails(");
        sb.append("super=").append(super.toString());
        sb.append("timeExpires=").append(String.valueOf(this.timeExpires));
        sb.append(", scopes=").append(String.valueOf(this.scopes));
        sb.append(", packagingConfigId=").append(String.valueOf(this.packagingConfigId));
        sb.append(", assetIds=").append(String.valueOf(this.assetIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateSessionTokenDetails)) {
            return false;
        }
        GenerateSessionTokenDetails other = (GenerateSessionTokenDetails)((Object)o);
        return Objects.equals(this.timeExpires, other.timeExpires) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.packagingConfigId, other.packagingConfigId) && Objects.equals(this.assetIds, other.assetIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeExpires == null ? 43 : this.timeExpires.hashCode());
        result = result * 59 + (this.scopes == null ? 43 : this.scopes.hashCode());
        result = result * 59 + (this.packagingConfigId == null ? 43 : this.packagingConfigId.hashCode());
        result = result * 59 + (this.assetIds == null ? 43 : this.assetIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Scopes implements BmcEnum
    {
        Playlist("PLAYLIST"),
        Edge("EDGE");

        private final String value;
        private static Map<String, Scopes> map;

        private Scopes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scopes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Scopes: " + key);
        }

        static {
            map = new HashMap<String, Scopes>();
            for (Scopes v : Scopes.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeExpires")
        private Date timeExpires;
        @JsonProperty(value="scopes")
        private List<Scopes> scopes;
        @JsonProperty(value="packagingConfigId")
        private String packagingConfigId;
        @JsonProperty(value="assetIds")
        private List<String> assetIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeExpires(Date timeExpires) {
            this.timeExpires = timeExpires;
            this.__explicitlySet__.add("timeExpires");
            return this;
        }

        public Builder scopes(List<Scopes> scopes) {
            this.scopes = scopes;
            this.__explicitlySet__.add("scopes");
            return this;
        }

        public Builder packagingConfigId(String packagingConfigId) {
            this.packagingConfigId = packagingConfigId;
            this.__explicitlySet__.add("packagingConfigId");
            return this;
        }

        public Builder assetIds(List<String> assetIds) {
            this.assetIds = assetIds;
            this.__explicitlySet__.add("assetIds");
            return this;
        }

        public GenerateSessionTokenDetails build() {
            GenerateSessionTokenDetails model = new GenerateSessionTokenDetails(this.timeExpires, this.scopes, this.packagingConfigId, this.assetIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerateSessionTokenDetails model) {
            if (model.wasPropertyExplicitlySet("timeExpires")) {
                this.timeExpires(model.getTimeExpires());
            }
            if (model.wasPropertyExplicitlySet("scopes")) {
                this.scopes(model.getScopes());
            }
            if (model.wasPropertyExplicitlySet("packagingConfigId")) {
                this.packagingConfigId(model.getPackagingConfigId());
            }
            if (model.wasPropertyExplicitlySet("assetIds")) {
                this.assetIds(model.getAssetIds());
            }
            return this;
        }
    }
}

